<?php

namespace App\Http\Controllers;

use App\Models\Caisse;
use Illuminate\Http\Request;

class CaisseController extends Controller
{
    public function index()
    {
        $caisses = Caisse::orderBy('date','DESC')->get();
        return view('caisse.index', compact('caisses'));
    }

    public function create()
    {
        return view('caisse.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'montant_initial'=>'required|numeric',
            'ajout'=>'nullable|numeric',
            'date'=>'required|date'
        ]);

        Caisse::create($request->all());
        return redirect()->route('caisse.index');
    }

    public function edit($id)
    {
        $caisse = Caisse::findOrFail($id);
        return view('caisse.edit', compact('caisse'));
    }

    public function update(Request $request, $id)
    {
        $caisse = Caisse::findOrFail($id);

        $request->validate([
            'montant_initial'=>'required|numeric',
            'ajout'=>'nullable|numeric',
            'date'=>'required'
        ]);

        $caisse->update($request->all());
        return redirect()->route('caisse.index');
    }

    public function destroy($id)
    {
        Caisse::destroy($id);
        return redirect()->route('caisse.index');
    }
}
