<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PostController extends Controller
{
    public function index()
    {
        $posts = Post::with('user')->get();
        return view('posts.index', compact('posts'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
        ]);

        Post::create([
            'titre' => $request->titre,
            'user_id' => Auth::id(), // utilisateur connecté
        ]);

        return redirect()->back()->with('success', 'Post ajouté avec succès');
    }

    public function update(Request $request, Post $post)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
        ]);

        $post->update(['titre' => $request->titre]);
        return redirect()->back()->with('success', 'Post mis à jour');
    }

    public function destroy(Post $post)
    {
        $post->delete();
        return redirect()->back()->with('success', 'Post supprimé');
    }
}
