<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Post;
use App\Models\User; // pour la liste déroulante

class PostController extends Controller
{
    public function index()
    {
        $posts = Post::with('user')->orderBy('id', 'desc')->get();
        $users = User::all(); // récupère tous les utilisateurs pour la dropdown
        return view('posts.index', compact('posts', 'users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
            'user_id' => 'required|exists:users,id',
        ]);

        Post::create([
            'titre' => $request->titre,
            'user_id' => $request->user_id,
        ]);

        return redirect()->back()->with('success', 'Post ajouté avec succès.');
    }

    public function update(Request $request, Post $post)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
            'user_id' => 'required|exists:users,id',
        ]);

        $post->update([
            'titre' => $request->titre,
            'user_id' => $request->user_id,
        ]);

        return redirect()->back()->with('success', 'Post mis à jour avec succès.');
    }

    public function destroy(Post $post)
    {
        $post->delete();
        return redirect()->back()->with('success', 'Post supprimé avec succès.');
    }
}
