<?php

namespace App\Http\Controllers;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    /**
     * Affiche la page d'accueil de l'utilisateur (facultatif)
 
  
     * Met à jour la localisation (latitude / longitude) de l'utilisateur connecté
     */
    public function updateLocation(Request $request)
    {
        // ✅ Validation des données reçues
        $request->validate([
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
        ]);

        // ✅ Récupération de l'utilisateur connecté
        $user = Auth::user();

        // ✅ Mise à jour des coordonnées
        $user->latitude = $request->latitude;
        $user->longitude = $request->longitude;
        $user->save();

        // ✅ Retour d'une réponse JSON
        return response()->json([
            'success' => true,
            'message' => 'Localisation mise à jour avec succès.',
            'data' => [
                'latitude' => $user->latitude,
                'longitude' => $user->longitude
            ]
        ]);
    }

       public function index()
    {
        $users = User::orderBy('name')->get();
        return view('users.index', compact('users'));
    }
}
