<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    public function handle(Request $request, Closure $next, $role): Response
    {
        if (!auth()->check()) {
            abort(403, 'أنت غير مسجل الدخول.');
        }

        if (!auth()->user()->hasRole($role)) {
            abort(403, 'أنت لا تملك الصلاحية للدخول إلى هذه الصفحة.');
        }

        return $next($request);
    }
}

