<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToArray;
use Maatwebsite\Excel\Concerns\WithCalculatedFormulas;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class RawImport extends DefaultValueBinder implements ToArray, WithCalculatedFormulas, WithCustomValueBinder
{
    public function bindValue(Cell $cell, $value)
    {
        // نحول كل القيم للنصوص باش ميوقعش 2.12E+11
        if (is_numeric($value)) {
            // خاص نحافظ على العدد كامل بلا صيغة علمية
            $cell->setValueExplicit(number_format($value, 0, '', ''), DataType::TYPE_STRING);
        } else {
            $cell->setValueExplicit((string)$value, DataType::TYPE_STRING);
        }

        return true;
    }

    public function array(array $array)
    {
        return $array;
    }
}
