<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
protected $fillable = [
    'name',
    'email',
    'password',
 
];

 
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public function roles()
{
    return $this->belongsToMany(Role::class, 'user_roles');
}

/*
public function roles()
{
    return $this->belongsToMany(Role::class, 'user_role', 'user_id', 'role_id');
}
*/

public function hasRole($role)
{
    return $this->roles()->where('name', $role)->exists();
}
      public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // 🔹 العلاقة مع المدينة
    public function ville()
    {
        return $this->belongsTo(Ville::class);
    }
      public function portfolio()
    {
        return $this->hasOne(Portfolio::class);
    }
    public function notifications()
{
    return $this->hasMany(Notification::class);
}

public function getRoleNames()
{
    return $this->roles->pluck('name'); // collection de noms
}
public function services()
{
    return $this->hasMany(Service::class);
}


// آراء المستخدمين اللي عطاو رأي على الحرفي
public function givenOpinions()
{
    return $this->hasMany(Opinion::class, 'user_id');
}

// آراء مستقبلة على الحرفي
public function opinions()
{
    return $this->hasMany(Opinion::class, 'employer_id');
}

public function posts()
{
    return $this->hasMany(Post::class, 'user_id');
}

}
