<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CommandeController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\CategorieController;
use App\Http\Controllers\ProduitController;
use App\Http\Controllers\DistributeurController;
use App\Http\Controllers\ChargrmrntController;
use App\Http\Controllers\RetourController;
use App\Http\Controllers\EncaissementController;
use App\Http\Controllers\VendeurController;
use App\Models\Distributeur; 
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();
//Route::resource('clients', App\Http\Controllers\ClientController::class);
Route::get('/localisation', [CategorieController::class, 'localisation']);

Route::resource('categories', CategorieController::class);
Route::resource('produits', ProduitController::class);

Route::resource('commandes', CommandeController::class);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::resource('distributeurs', DistributeurController::class);
Route::resource('chargements', ChargrmrntController::class);
Route::get('/chargements1', [ChargrmrntController::class,'index'])->name('chargements.index');
Route::get('/chargements/create', [ChargrmrntController::class,'create'])->name('chargements.create');
Route::post('/chargements', [ChargrmrntController::class,'store'])->name('chargements.store');

Route::resource('retours', RetourController::class);


Route::post('/retours', [RetourController::class, 'store'])->name('retours.store');
Route::get('/retours/produits/{chargement}', [RetourController::class, 'produitsByChargement']);
Route::get('/retours/produits/{id}', [RetourController::class, 'produits']);
//Route::get('/retours/produits/{chargement}', [RetourController::class, 'getProduits']);

/*
Route::post('/retours', [RetourController::class, 'store'])->name('retours.store');

Route::get('/retours/produits/{id}', [RetourController::class, 'produits'])->name('retours.produits');
*/

Route::get('/retours/produits/{chargement}', [RetourController::class, 'produits'])->name('retours.produits');

Route::resource('encaissements', EncaissementController::class);

// Optionnel pour créer automatique encaissement par chargement
Route::get('encaissements/create/{chargement}', [EncaissementController::class, 'store'])->name('encaissements.create');
Route::get('/encaissements/create/{chargementId?}', [EncaissementController::class, 'create'])->name('encaissements.create');
Route::post('/encaissements', [EncaissementController::class, 'store'])->name('encaissements.store');




Route::prefix('vendeur')->middleware(['auth'])->group(function () {

    // Dashboard vendeur
    Route::get('dash', [VendeurController::class, 'dash'])->name('vendeur.dash');

    // Liste clients pour mabi3a
    Route::get('mabi3a', [VendeurController::class, 'listeClients'])->name('vendeur.mabi3a');

    // Client choisi / chargements pour client
    Route::get('mabi3a/client/{client}', [VendeurController::class, 'chargement'])->name('vendeur.mabi3a.client');

    // Stocker vente
    Route::post('mabi3a/store', [VendeurController::class, 'storeVente'])->name('vente.store');
    Route::post('/panier/update', [VendeurController::class, 'updatePanier'])->name('vendeur.panier.update');

});


// =================== VENDEUR PANIER ===================

Route::prefix('vendeur')->middleware(['auth'])->group(function () {
    Route::get('/clients', [VendeurController::class, 'listeClients'])->name('vendeur.clients');
    Route::get('/chargement/{client}', [VendeurController::class, 'chargement'])->name('vendeur.chargement');
     Route::get('/newchargement', [VendeurController::class, 'newchargement'])->name('vendeur.newchargement');

    // Panier
Route::get('/panier/{client}/{chargement}', [VendeurController::class, 'panier'])->name('vendeur.panier');
    Route::post('/panier/add', [VendeurController::class, 'ajouterAuPanier'])->name('vendeur.panier.add');
    Route::post('/panier/remove', [VendeurController::class, 'supprimerDuPanier'])->name('vendeur.panier.remove');
    Route::post('/panier/enregistrer', [VendeurController::class, 'enregistrerVente'])->name('vendeur.panier.enregistrer');
    Route::get('/panier/confirmation', [VendeurController::class, 'confirmation'])->name('vendeur.panier.confirmation');

Route::get(
    'vendeur/client/{client}/chargements',
    [VendeurController::class, 'chargementsParClient']
)->name('vendeur.chargements.client');

Route::get(
    'vendeur/client/{client}/chargement/{chargement}',
    [VendeurController::class, 'produitsParChargement']
)->name('vendeur.produits');
    
});

   Route::get('usercharg', [VendeurController::class, 'usercharg'])
    ->name('usercharg');

 Route::get('show/{id}', [VendeurController::class, 'show'])->name('show');

Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dash'])
    ->name('dashboard')
    ->middleware('auth', 'checkrole:admin');

Route::get('/dashvendeur', [VendeurController::class, 'dashvendeur'])
    ->name('dashvendeur')
     ->middleware('auth', 'checkrole:user');

Route::post('/vendeur/panier/remove', 
    [VendeurController::class, 'remove'])->name('vendeur.panier.remove');


Route::get('/client', [App\Http\Controllers\ClientController::class, 'index'])
    ->name('client')
    ->middleware('roles:client');


Route::get('/vendeur/vente/{id}', [VendeurController::class, 'ventedetail'])->name('vendeur.ventedetail');
Route::get('/vendeur/clients', [VendeurController::class, 'listeClients'])
    ->name('vendeur.listeClients');
//chargemnt
Route::middleware('auth:sanctum')->get('/chargements', [ChargrmrntController::class, 'indexApi']);
