<?php

namespace App\Http\Controllers;

use App\Models\alimentcaisse;
use App\Models\caisse;
use Illuminate\Http\Request;

class AlimentcaisseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $aliment=  alimentcaisse::orderBy('created_at','desc')->paginate(10);
        return view('admin.alimentcaisse',['aliment'=>$aliment
    ]);
     
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
     
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $aliment= new alimentcaisse();
        $aliment->aliment=$request->cat;
        $aliment->prix=$request->prix;
   

        $aliment->save();
        $caisse = new caisse();
        $caisse->montant = $request->prix;  // Montant total de la vente
        // Montant total de la vente
        $caisse->typecasse_id = 2;          // Associer à la vente
        $caisse->save();
     
        return redirect()->back()->with('success', ' bien supprimer'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\alimentcaisse  $alimentcaisse
     * @return \Illuminate\Http\Response
     */
    public function show(alimentcaisse $alimentcaisse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\alimentcaisse  $alimentcaisse
     * @return \Illuminate\Http\Response
     */
    public function edit(alimentcaisse $alimentcaisse)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\alimentcaisse  $alimentcaisse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $aliment=  alimentcaisse::where('id',$id)->first();
        $aliment->aliment=$request->cat;
        $aliment->prix=$request->prix;
   

        $aliment->save();
     
        return redirect()->back()->with('success', ' bien supprimer'); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\alimentcaisse  $alimentcaisse
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $aliment=  alimentcaisse::where('id', $id)->first();
        $aliment->delete();
        return redirect()->back()->with('success', ' bien supprimer'); 
    }
}
