<?php

namespace App\Http\Controllers;
use App\Models\produit;
use App\Models\stock;
use App\Models\encour;
use App\Models\detaille_boncommande;   
use App\Models\fournisseur;
use App\Models\boncommande;
use \Carbon\Carbon;
use App\Models\hystorique_factur;
use Illuminate\Http\Request;

class BoncommandeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       
        return view('admin.commande');
    }

  
    public function facturboncommande()
    {
        $boncommandes=boncommande::orderBy('created_at','desc')->paginate(10);
        return view('admin.facturecommande',['boncommandes'=>$boncommandes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $boncommande= new boncommande();
        $boncommande->user_id=Auth()->user()->id;
        $boncommande->prixtotal=$request->prixtotal;
        $boncommande->fournisseur_id=$request->idclient;
        $boncommande->ref=233;
        $boncommande->save();
 

         if($boncommande->save()){
            foreach ($request->cart as $item) {

                $detaille_boncommande = new detaille_boncommande();
             
                $detaille_boncommande->boncommande_id = $boncommande->id;
                $detaille_boncommande->desc = $item['desc'];
                $detaille_boncommande->quantite = $item['quantite'];
                $detaille_boncommande->prix_vente = $item['prixvente'];
          
                $detaille_boncommande->total = $item['total'];
                $detaille_boncommande->save();
              
               
            
              
         }
       

        return redirect()->back()->with('success', ' bien enregistrer');
        }}
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function show(boncommande $boncommande)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
public function modifier($id)
{
    $boncommande = Boncommande::with('detaille_boncommande')->findOrFail($id);
    $fournisseurs = Fournisseur::all();
    return view('admin.editboncommande', compact('boncommande', 'fournisseurs'));
}






public function update(Request $request, $id)
{
    $boncommande = Boncommande::findOrFail($id);

    $boncommande->fournisseur_id = $request->fournisseur_id;
    $boncommande->prixtotal = $request->prixtotal;
    $boncommande->save();

    $boncommande->detaille_boncommande()->delete();

    foreach($request->cart as $item){
        $boncommande->detaille_boncommande()->create([
            'desc' => $item['desc'],
            'quantite' => $item['qty'],
            'prix_vente' => $item['prix'],
            'remise' => $item['remise'],
            'tva' => $item['tva'],
            'total' => $item['total']
        ]);
    }

    return response()->json([
        'success' => true,
        'message' => 'Bon de commande modifié avec succès'
    ]);
}





    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $boncommande = boncommande::where('id', $id)->first();


        $detaille_boncommande = detaille_boncommande::where('boncommande_id', $boncommande->id)->get();
        
       foreach ($detaille_boncommande as $det) {
            $det->delete();
        }
        $boncommande->delete();

   
 
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
