<?php

namespace App\Http\Controllers;

use App\Models\categorie;
use App\Models\lieustock;
use App\Models\Topcat;
use App\Models\produit;
use Illuminate\Http\Request;

class CategorieController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function addcatt()
    {
        //
    }
    public function categorie()
    {
        $categories= categorie::with('Topcat','lieustock')->get();
 
        return response()->json(['categories'=>$categories]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
        $topcats= Topcat::all();
        $categories= categorie::all();
        $lieustock=lieustock::all();
        return view('admin.categorie',[
                 'lieustock'=>$lieustock,
                 'topcats'=>$topcats,
                 'categories'=>$categories,
                
       
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $imageName='';
        if($request->hasFile('image')){
        $imageName = time().'.'.$request->image->getClientOriginalExtension();  
     
        $request->image->move(public_path('img'), $imageName);
        }
        $categorie= new categorie();
        $categorie->cat=$request->categorie;
        $categorie->lieustock_id=$request->lieustock;
        $categorie->topcat_id=$request->topcat;
        $categorie->img=$imageName;
        $categorie->save();
        return redirect()->back()->with('success', ' bien enregistrer');
    }






    public function store1(Request $request)
    {
    
        $imageName='';
        if($request->hasFile('image')){
        $imageName = time().'.'.$request->image->getClientOriginalExtension();  
     
        $request->image->move(public_path('img'), $imageName);
        }

       
     
        $categorie= new categorie();
        $categorie->lieustock_id=$request->lieustock;
        $categorie->topcat_id=$request->topcat;
        $categorie->cat=$request->categorie;
        $categorie->img=$imageName;
        $categorie->save();
        return redirect()->back()->with('success', ' bien enregistrer');
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\categorie  $categorie
     * @return \Illuminate\Http\Response
     */
    public function categoriebyid( $id)
    {
        $categorie= produit::where('categorie_id',$id)->get();
 
        return response()->json(['categorie'=>$categorie]);
    }



    public function categorie_lieu($id)
    {
        $categorie= categorie::where('lieustock_id',$id)->get();
 
        return response()->json(['categorie'=>$categorie]);
    }

    public function categorie_topcat($id)
    {
        $categories= categorie::where('topcat_id',$id)->get();
 
        return response()->json(['categories'=>$categories]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\categorie  $categorie
     * @return \Illuminate\Http\Response
     */
    public function edit(categorie $categorie)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\categorie  $categorie
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, categorie $categorie)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\categorie  $categorie
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
   
        $categorie=categorie::where('id',$id)->first();
        produit::where('topcat_id',$id)->delete();
    $categorie->delete();
    return response()->json(['status'=>'success','data'=>$categorie]);

}
}
