<?php

namespace App\Http\Controllers;
use App\Models\detaille_devis;
use App\Models\devis;
use App\Models\Vente;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use App\Models\client;
use App\Models\hystorique_factur;
use Illuminate\Support\Facades\Auth;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;

use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;
class DevisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.devis');
    }
    public function facturdevis()
    {
        $devis=devis::orderBy('created_at','desc')->paginate(10);
        return view('admin.facturdevis',['devis'=>$devis]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
 

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
   

        $devis= new devis();
        $devis->user_id=Auth()->user()->id;
        $devis->prixtotal=$request->prixtotal;
        $devis->client_id=$request->idclient;
        $devis->ref=22;
        $devis->prixtotal = $request->prixtotal;  
        $devis->totalTVA = $request->totaltva;
        $devis->totalavecTVA = $request->totalavecTVA;
        $devis->totalremise = $request->totalremise;
  
 
         $devis->save();
       
         if($devis->save()){
            foreach ($request->cart as $item) {

                $detaille_devis = new detaille_devis();
                $detaille_devis->devis_id = $devis->id;
                $detaille_devis->desc = $item['desc'];
                $detaille_devis->quantite = $item['quantite'];
                $detaille_devis->prix_vente = $item['prixvente'];
          
                $detaille_devis->total = $item['total'];
             
            
           
                $detaille_devis->save();

               
        
            
           
             
      

           
                   
        }
            
              
         }
       

        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function show(devis $devis)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
public function edit($id)
{
    $devis = devis::with('detaille_devis')->findOrFail($id);
    $clients = client::all(); // si tu veux un select pour changer le client
    return view('admin.editdevis', compact('devis', 'clients'));
}


public function update(Request $request, $id)
{
    $devis = devis::findOrFail($id);

    $devis->prixtotal = $request->prixtotal;
    $devis->totalTVA = $request->totaltva;
    $devis->totalavecTVA = $request->totalavecTVA;
    $devis->totalremise = $request->totalremise;
    $devis->client_id = $request->idclient;
    $devis->save();

    detaille_devis::where('devis_id', $id)->delete();

    foreach ($request->cart as $item) {
        detaille_devis::create([
        'devis_id'   => $devis->id,
        'desc'       => $item['desc'],
        'quantite'   => $item['qty'],
        'prix_vente' => $item['prix'],
        'remise'     => $item['remise'] ?? 0,
        'tva'        => $item['tva'] ?? 0,
        'total'      => $item['total']
        ]);
    }

    return response()->json(['success' => true]);
}



public function chowtoVente($id)
{
    $devis = devis::with('detaille_devis')->findOrFail($id);
    $clients = client::all();
     $modepayements = \App\Models\modepayement::all();
    return view('admin.devis_to_vente', compact('devis', 'clients','modepayements'));
}


    // Convertir le devis en vente
public function storeVente(Request $request, $id)
{
    $devis = devis::findOrFail($id);

    // Créer la vente
    $vente = new Vente();
    $vente->user_id = Auth::id();
    $vente->ref = 'V-' . $devis->id . '-' . time();
    $vente->client_id = $request->idclient ?? $devis->client_id;
    $vente->modepayement_id = $request->modepayement_id;
    $vente->prixtotal = $request->prixtotal;
    $vente->totalTVA = $request->totalTVA;
    $vente->totalremise = $request->totalremise;
    $vente->totalavecTVA = $request->prixtotal;
    $vente->encour_id = 1;

    // Gestion du paiement
    if ($request->modepayement_id == 1 || $request->modepayement_id == 3) { // Espèce ou Chèque
        $vente->avance = $request->prixtotal;
        $vente->rest = 0;
    } elseif ($request->modepayement_id == 2) { // Crédit
        $vente->avance = $request->avance ?? 0;
        $vente->rest = $request->prixtotal - $vente->avance;
    }

    $vente->save();

    // Enregistrer les détails
    if(is_array($request->cart)){
        foreach ($request->cart as $item) {
            $detail = new detaille_vente();
            $detail->vente_id = $vente->id;
            $detail->desc = $item['desc'] ?? '';
            $detail->quantite = $item['qty'] ?? 0;
            $detail->prix_vente = $item['prix'] ?? 0;
            $detail->tva = $item['tva'] ?? 0;
            $detail->remise = $item['remise'] ?? 0;
            $detail->total = $item['total'] ?? 0;
            $detail->save();
        }
    }

    return response()->json([
        'message' => 'Devis converti en vente avec succès !',
        'redirect' => route('devis.ventedevis', $id)
     
    ]);
}




    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */

    public function genererNumeroFacture()
    {
        // Récupérer le dernier ID dans la table 'vente'
        $dernierId = devis::max('id');
    
        // Calculer le prochain ID
        $prochainId = $dernierId ? $dernierId + 1 : 1;
    
        // Générer le numéro de facture adapté
        $numeroFacture = $prochainId;
    
        // Retourner une réponse JSON
        return response()->json([
            'success' => true,
            'numero_facture' => $numeroFacture,
        ]);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $devis = devis::where('id', $id)->first();
       
      
        $detaille_devis = detaille_devis::where('devis_id', $devis->id)->get();
        
       foreach ($detaille_devis as $det) {
            $det->delete();
        }
        $devis->delete();

   
 
        return redirect()->back()->with('success', ' bien supprimer');
    }


}
