<?php

namespace App\Http\Controllers;

use App\Models\info;
use Illuminate\Http\Request;

class InfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function info()
    {
    $info=info::first();
    return view('admin.info',['info'=>$info]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
 public function store(Request $request)
{
    $infoall = info::first(); // Un seul enregistrement

    if (!$infoall) { // Si aucun enregistrement
        $imageName = '';
        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->getClientOriginalExtension();  
            $request->image->move(public_path('img'), $imageName);
        }

        $info = new info();
        $info->nom = $request->nom;
        $info->tele = $request->tele;
        $info->adress = $request->adress;
        $info->rib = $request->rib;
        $info->ice = $request->ice;
        $info->logo = $imageName;

        // Ajout des nouvelles lignes
        $info->line1 = $request->line1;
        $info->line2 = $request->line2;
        $info->line3 = $request->line3;

        $info->save();

        return redirect()->back()->with('success', 'Bien enregistré');
    } else { // Si déjà un enregistrement → on met à jour
        $imageName = '';
        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->getClientOriginalExtension();  
            $request->image->move(public_path('img'), $imageName);
        }

        $info = $infoall;
        $info->nom = $request->nom;
        $info->tele = $request->tele;
        $info->adress = $request->adress;
        $info->rib = $request->rib;
        $info->ice = $request->ice;

        if (!empty($imageName)) {
            $info->logo = $imageName; // Met à jour uniquement si nouvelle image
        }

        // Mise à jour des nouvelles lignes
        $info->line1 = $request->line1;
        $info->line2 = $request->line2;
        $info->line3 = $request->line3;

        $info->save();

        return redirect()->back()->with('success', 'Bien enregistré');
    }
}


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\info  $info
     * @return \Illuminate\Http\Response
     */
    public function show(info $info)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\info  $info
     * @return \Illuminate\Http\Response
     */
    public function edit(info $info)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\info  $info
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, info $info)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\info  $info
     * @return \Illuminate\Http\Response
     */
    public function destroy(info $info)
    {
        //
    }
}
