<?php

namespace App\Http\Controllers;
use App\Models\categorie;
use App\Models\produit;
use App\Models\fournisseur;
use App\Models\stock;
use App\Models\caisse;
use App\Models\Topcat;
use App\Models\hystoriqprix;
use Illuminate\Http\Request;
use Validator;

class ProduitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

 

     public function document()
     {
        
         return view('admin.document');
     }
 
     public function comptabilite()
     {
        
         return view('admin.comptabilite');
     }
     public function modifrix()
     {
        $topcats= Topcat::all();
         return view('admin.mdifprix',['topcats'=> $topcats]);
     }

     public function modifrixstor(Request $request)
     {
     //   dd($request->all());
    $produit=produit::where('topcat_id',$request->topcat)->get();
    foreach($produit as $rod){
        $x=$rod->prixun*$request->pourcentage/100;
        $rod->prixun+=  $x;
          $rod->save();
    }
  
    return back();
    //pourcentage topcat
     }
     public function index()
     {
        $totale= produit::all();
     
        $produits = Produit::orderBy('created_at', 'desc')->paginate(10);// Récupérer 10 produits par page
         $categories = Topcat::all();
         $fournisseurs = Fournisseur::all();
         $stocks = Stock::paginate(10); 
     
         // Calcul du total global du capital
         $totalCapital = Produit::selectRaw('SUM(stock * prixun) as total_capital')
             ->value('total_capital');
     
         return view('admin.produit', [
             'produits' => $produits,
             'categories' => $categories,
             'fournisseurs' => $fournisseurs,
             'totalCapital' => $totalCapital,
             'totale'=>$totale,
             'stocks'=>$stocks,
         ]);
     }
     
     





    public function produits()
    {   $total = 0;
        $produits= produit::with('lieustock','fournisseur','topcat')->get();
        foreach($produits as $prod){
           
            $total+=$prod->prixun*$prod->stock;
        }
 
        return response()->json(['produits'=>$produits,'total'=>$total]);
    }

    public function lastid() {
         $produit=produit::latest('id')->first();
        $lastd=$produit->id+1;
        return response()->json(['lastd'=>$lastd]);
     }
    public function produitbyid($id)
    {
   
       
        $produit= produit::where(
            [
            ['id','=',$id],
            [ 'stock','>' ,0]
            ]
            )->first();
 
        return response()->json(['produit'=>$produit]);
    }

    public function getproduitbycat($id)
    {
        $produits= produit::where(
            [
            
           [ 'topcat_id','=' ,$id],
           [ 'stock','>' ,0]
        ]  )->get();
        
      
 
        return response()->json(['produits'=>$produits]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    
 

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

 public function alert()
{
    $produits = Produit::whereColumn('stock', '<=', 'minqty')->paginate(10); // pagination
    $produitstot = Produit::whereColumn('stock', '<=', 'minqty')->get(); // tout sans pagination

    return view('admin.alert', [
        'produits' => $produits,
        'produitstot' => $produitstot,
    ]);
}


     public function inventair()
     {
        $produits= produit::paginate(10); 
      
        return view('admin.inventair',['produits'=>$produits]);

     }
     
     
     
     public function searchinv(Request $request)
     {

      
         $query = $request->input('search'); // Récupère le terme de recherche
         
         // Recherche uniquement par référence
         $produits = produit::where('nom', 'LIKE', "%$query%")
        ->paginate(10); 
     
        return view('admin.inventair',['produits'=>$produits]);
     }
     
     
     
     public function inventairupdat(Request $request, $id)
     {
        $produit = produit::find($id);
        $produit->stock = $request->qty;
        $produit->save();
     
        // Rediriger en arrière après la mise à jour
        return back();
        
     }

     public function qtyupdat(Request $request, $id)
     {
        $produit = produit::find($id);
        $produit->stock += $request->qty;
        $produit->save();
     
        // Rediriger en arrière après la mise à jour
        return back();
        
     }
     
     
     
     
     
     
     public function updatproduit(Request $request, $id)
     {
       // dd($request->all());
         // Trouver le produit existant
         $produit = produit::find($id);
         
         // Vérifier si une nouvelle image a été sélectionnée
         if ($request->hasFile('image')) {
             // Générer un nouveau nom pour l'image
             $imageName = time() . '.' . $request->image->getClientOriginalExtension();
             $path = 'img';
             
             // Déplacer l'image dans le dossier 'public/img'
             $request->image->move($path, $imageName);
             
             // Mettre à jour l'image du produit
             $produit->img =  $imageName;
         }



       




         // Si aucune nouvelle image n'a été sélectionnée, ne pas changer l'image
         // La ligne suivante permet de conserver l'image existante
         else {
             // Ne rien faire, l'image actuelle est conservée
             // $produit->img reste inchangé
         }
         
         // Mise à jour des autres champs
         $produit->user_id = Auth()->user()->id;
         $produit->nom = $request->nom;
       $produit->minqty=$request->minqty;
         $produit->topcat_id = $request->cat;
         $produit->prixun = $request->prixun;
         $produit->prixvents = $request->prixvente;
         $produit->ref = $request->ref;
         $produit->stock = $request->qty; // quantité
          $produit->com="rien";
        
       
         
         // Sauvegarder les modifications
         $produit->save();
     
         // Rediriger en arrière après la mise à jour
         return back();
     }
     
    public function store(Request $request,$id)
    {
dd('hn ');

        $imageName='';
        if($request->hasFile('image')){
        $imageName = time().'.'.$request->image->getClientOriginalExtension();  
     
        $request->image->move(public_path('img'), $imageName);
        }
     
      
       
        $produit= new produit();
        $produit->user_id=Auth()->user()->id;
        $produit->nom=$request->nom;
        $produit->codebar="undifind";
        $produit->ref=$request->ref;
        $produit->com=$request->com;
        $produit->gain=2;
        $produit->fournisseur_id=$request->idfournisseur;
       
        $produit->lieustock_id=$request->idlieutoock;
        $produit->topcat_id=$request->idtopcat;
        $produit->prixun=$request->prixun;
        $produit->prixvents=77;
        $produit->minqty=2;
        $produit->qty=$request->qty;
        $produit->stock=$request->qty;//quntite
        $produit->datemajoration=date('Y-m-d H:i:s');
        $produit->img=$imageName;
        
        $produit->save();
if( $produit->save()){
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=$produit->id;
    $stock->mouvement_id=1;
    $stock->qty=$produit->qty;
$stock->save();

$caisse= new caisse();
$caisse->entrer=0;
$caisse->srtie=$request->prixun*$request->qty;
$caisse->justif="entrer en  stoock";
$caisse->save();

    
}
 
    }



  
 
 
  
  










    /**
     * Display the specified resource.
     *
     * @param  \App\Models\produit  $produit
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $stocks= stock::where('produit_id',$id)->get();
        $produit= produit::where('id',$id)->first();

        return view('admin.detaille',['produit'=>$produit,'stocks'=>$stocks]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\produit  $produit
     * @return \Illuminate\Http\Response
     */
    public function chercheproduit(Request $request)
    {
    $xx=$request->qr;
  
       $produit=produit::where('nom', 'like', "%$xx%")->first();
       return view('admin.chercheproduit',[ 'produit'=>$produit]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\produit  $produit
     * @return \Illuminate\Http\Response
     */
    public function addproduit2(Request $request)
    {
        $request->validate([
            'nom' => 'required|string|max:255',
            'cat' => 'required',
            'prixun' => 'required|numeric',
            'prixvents' => 'required|numeric',
            'qty' => 'required|integer',
        ], [
            'nom.required' => 'Le champ Désignation est obligatoire.',
   
            'cat.required' => 'La catégorie est obligatoire.',
            'prixun.required' => 'Le prix unitaire est obligatoire.',
            'prixun.numeric' => 'Le prix unitaire doit être un nombre.',
            'prixvents.required' => 'Le prix de vente est obligatoire.',
            'prixvents.numeric' => 'Le prix de vente doit être un nombre.',
            'qty.required' => 'La quantité est obligatoire.',
            'qty.integer' => 'La quantité doit être un nombre entier.',
        ]);
        


     
         $imageName='';
        if($request->hasFile('image')){
        $imageName = time().'.'.$request->image->getClientOriginalExtension();  
        $path = 'img';
        $request->image->move($path, $imageName);
        }
     
      
       
        $produit= new produit();
        $produit->user_id=Auth()->user()->id;
        $produit->nom=$request->nom;
      
        $produit->ref=$request->ref;
         $produit->minqty=$request->minqty;
    
        $produit->lieustock_id=1;
        $produit->topcat_id=$request->cat;
        $produit->prixun=$request->prixun;
        $produit->prixvents=$request->prixvents;
        $produit->com="rien";
     
        $produit->stock=$request->qty;//quntite
      
        $produit->img=$imageName;
        
        $produit->save();
        if( $produit->save()){
            $stock= new stock();
            $stock->user_id=Auth()->user()->id;
            $stock->produit_id=$produit->id;
            $stock->mouvement_id=1;
            $stock->qty=$produit->stock;
        $stock->save();
    }        


    return redirect()->back()->with('success', 'Produit ajouté avec succès.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\produit  $produit
     * @return \Illuminate\Http\Response
     */


     public function destroy($id)
     {
       
 
      

             $produit = produit::find($id);
 
         $produit->delete();
         return back();
    
 
         
     }
 

     public function codebar()
     {
       
      
        return view('admin.codebar');

     }


     public function search(Request $request)
     {
        $categories = Topcat::all();
        $fournisseurs = Fournisseur::all();
         $query = $request->input('search'); // Récupère le terme de recherche
     
         $produits = Produit::where('nom', 'LIKE', "%$query%")
             ->orWhere('ref', 'LIKE', "%$query%")
             ->orWhereHas('topcat', function ($q) use ($query) {
                 $q->where('nom', 'LIKE', "%$query%"); // Remplacez 'nom' par le champ correct dans votre table 'topcats'
             })
             ->paginate(10); 
             $totale= produit::all();
             $totalCapital = Produit::selectRaw('SUM(stock * prixun) as total_capital')
             ->value('total_capital');
     
         return view('admin.produit', [
             'produits' => $produits,
             'categories' => $categories,
             'fournisseurs' => $fournisseurs,
             'totalCapital' => $totalCapital,
             'totale'=>$totale
         ]);
     }
     
     
    public function searchealert(Request $request)
{
    $query = $request->input('search');

    // Recherche produits avec stock <= minqty ET ref ou nom qui contient la recherche
    $produits = Produit::where(function ($q) use ($query) {
            $q->where('ref', 'LIKE', "%$query%")
              ->orWhere('nom', 'LIKE', "%$query%");
        })
        ->whereColumn('stock', '<=', 'minqty')
        ->paginate(10);

    // Tous les produits avec stock <= minqty sans filtre recherche
    $produitstot = Produit::whereColumn('stock', '<=', 'minqty')->get();

    return view('admin.alert', [
        'produits' => $produits,
        'produitstot' => $produitstot,
    ]);
}




     public function produitparcat($id)
     {
        $topcat = Topcat::where('id',$id)->first();
        $produits = produit::where('topcat_id', $id) ->paginate(10); // Récupérer 10 produits par page
        $produitstot = produit::where('topcat_id', $id) ->get(); 
             
                 return view('admin.produitparcat', [
                     'produits' => $produits, 
                     'produitstot' => $produitstot, 
                     'topcat' => $topcat, 
                    
                 ]); 
     
     }
     
     public function searchepc(Request $request,$id)
     {
        $topcat = Topcat::where('id',$id)->first();
        $produitstot = produit::where('topcat_id', $id) ->get(); 
         $query = $request->input('search'); // Récupère le terme de recherche
         
         // Recherche uniquement par référence
         $produits = produit::where('ref', 'LIKE', "%$query%")
         ->where('topcat_id', $id) ->paginate(10); 
     
         return view('admin.produitparcat', [
             'produits' => $produits,
             'produitstot'=>$produitstot,
             'topcat' => $topcat, 
         ]);
     }









     }
     
     
     
     
     
     



