<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
public function roles()
{
    return $this->belongsToMany('App\Models\Role', 'user_roles', 'user_id', 'role_id');
}

public function hasAnyRole($roles)
{
    if (is_array($roles)) {
        foreach ($roles as $role) {
            if ($this->hasRole($role)) {
                return true;
            }
        }
        return false;
    }
    return $this->hasRole($roles);
}

public function hasRole($role)
{
    return $this->roles()->where('name', $role)->first() !== null;
}
    public function produit()
    {
        return $this->hasMany('App\Models\produit');
    }
    public function hystoriqprix()
    {
        return $this->hasMany('App\Models\hystoriqprix');
    }

    public function stock()
    {
        return $this->hasMany('App\Models\stock');
    }
    
    public function vente()
    {
        return $this->hasMany('App\Models\vente');
    }
    public function devis()
    {
        return $this->hasMany('App\Models\devis');
    }
    public function bonlivraison()
    {
        return $this->hasMany('App\Models\bonlivraison');
    }
    public function enattend()
    {
        return $this->hasMany('App\Models\enattend');
    }
    public function hystorique_factur()
    {
        return $this->hasMany('App\Models\hystorique_factur');
    }
}
