@extends('layouts.app')

@section('content')
{{-- إخفاء navbar --}}
<style>
  nav.navbar { display: none; }

  /* تكبير العنوان العلوي وجعله غامق */
  .alert.alert-success strong {
      font-size: 1.5rem; /* تكبير */
      font-weight: 700;  /* غامق */
  }

  /* تكبير النصوص داخل الفورم */
  label {
      font-size: 1.1rem;
      font-weight: 600;
  }

  /* تكبير الأزرار */
  button.btn {
      font-size: 1.1rem;
      font-weight: 600;
  }
</style>

<div class="bg-login min-vh-100 d-flex align-items-start justify-content-center py-4" dir="rtl">
    <div class="card shadow p-4" style="max-width: 600px; width: 100%; position: relative;">
        
        {{-- العنوان الثابت أعلى البطاقة --}}
        <div class="alert alert-success text-center mb-4" 
             style="position: sticky; top: 0; z-index: 10; width: 100%; border-radius:0;">
            <strong>إرسال طلب خدمة</strong>
        </div>

        {{-- رسالة النجاح --}}
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div style="max-height: 70vh; overflow-y: auto;"> {{-- محتوى قابل للتمرير --}}
        <form action="{{ route('alerts.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            {{-- كل الحقول --}}
            <div class="mb-3">
                <label>الفئة المطلوبة</label>
                <select name="category_id" class="form-control" required>
                    <option value="">اختر فئة</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label>المدينة</label>
                <select name="ville_id" class="form-control">
                    <option value="">اختياري</option>
                    @foreach($villes as $v)
                        <option value="{{ $v->id }}">{{ $v->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label>الوصف</label>
                <textarea name="description" class="form-control" rows="4"></textarea>
            </div>

            <div class="mb-3">
                <label>السعر المقترح</label>
                <input type="number" name="prix_propose" class="form-control" step="0.01">
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>التاريخ المطلوب</label>
                    <input type="date" name="date_demande" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>الوقت المطلوب</label>
                    <input type="time" name="heure_demande" class="form-control">
                </div>
            </div>

            <div class="mb-3">
                <label>صورة (اختياري)</label>
                <input type="file" name="photo" class="form-control">
            </div>

            <div class="mb-3">
                <label>العنوان</label>
                <input type="text" name="adresse" class="form-control">
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>خط العرض</label>
                    <input type="text" name="latitude" id="latitude" class="form-control" readonly>
                </div>
                <div class="col-md-6">
                    <label>خط الطول</label>
                    <input type="text" name="longitude" id="longitude" class="form-control" readonly>
                </div>
            </div>

            <button type="button" class="btn btn-outline-secondary mb-3 w-100" onclick="getLocation()">الحصول على موقعي</button>
            <button type="submit" class="btn btn-primary w-100">إرسال الطلب</button>
        </form>
        </div>
    </div>
</div>

<script>
function getLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            function(position) {
                document.getElementById('latitude').value = position.coords.latitude;
                document.getElementById('longitude').value = position.coords.longitude;
                alert("تم الحصول على الموقع بنجاح");
            },
            function() { alert("تم رفض الحصول على الموقع"); }
        );
    } else {
        alert("جهازك لا يدعم تحديد الموقع الجغرافي");
    }
}
</script>
@endsection

{{-- Footer ثابت --}}
<footer style="position: fixed; bottom: 0; left: 0; right: 0; height: 60px; background: #f8f9fa; display: flex; justify-content: space-around; align-items: center; border-top: 1px solid #ddd; z-index: 1050;" dir="rtl">
    
    {{-- زر الرئيسية --}}
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">الرئيسية</span>
    </a>

    {{-- زر لوحة التحكم --}}
    @php
        $dashboardUrl = url('/home'); // افتراضي
        if(Auth::check()) {
            if(Auth::user()->is_admin) {
                $dashboardUrl = route('admin.dashboard');
            } elseif(Auth::user()->is_employer) {
                $dashboardUrl = route('employer.dashboard');
            } else {
                $dashboardUrl = route('user.dashboard');
            }
        }
    @endphp
    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">لوحة التحكم</span>
    </a>
</footer>

{{-- Bootstrap Icons --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
