@extends('layouts.app')

@section('content')
<style>
    /* 🔹 إخفاء navbar */
    nav.navbar { display: none !important; }

    /* 🔹 Alert ثابتة فوق */
    .alert-primary-fixed {
        position: fixed;
        top: 0; left: 0; right: 0;
        z-index: 1050; margin: 0; border-radius: 0;
        border: none; background-color: #007bff; color: white;
        display: flex; align-items: center; justify-content: center;
        font-weight: 600; height: 50px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        direction: rtl; text-align: center;
    }

    /* صفحة الاستقبال */
    .welcome-page { 
        display: flex; align-items: flex-start; justify-content: center; 
        min-height: 100vh; background: linear-gradient(135deg, #007bff, #00c6ff); 
        padding: 16px; padding-top: 60px; /* مساحة بسيطة تحت Alert */
    }

    /* البطاقة الرئيسية */
    .card { 
        background: white; border-radius: 20px; 
        padding: 25px 20px; width: 100%; max-width: 380px; 
        text-align: right; direction: rtl; font-weight: 600;
        box-shadow: 0 12px 30px rgba(0,0,0,0.15); animation: fadeIn 0.6s ease;
    }

    .title { font-weight: 700; font-size: 22px; color: #333; margin-bottom: 8px; }
    .subtitle { color: #666; font-size: 13px; margin-bottom: 15px; }

    .input-group { margin-bottom: 15px; text-align: right; }
    .input-group label { font-weight: 600; color: #333; margin-bottom: 6px; display: block; }
    .input-group input { width: 100%; padding: 10px 12px; border: 1px solid #ddd; border-radius: 10px; font-size: 14px; transition: 0.2s ease; }
    .input-group input:focus { border-color: #00aaff; outline: none; }
    .error { color: #ff3b3b; font-size: 12px; }

    .options { display: flex; justify-content: space-between; align-items: center; font-size: 13px; margin-bottom: 15px; }

    .btn-login { width: 100%; background: linear-gradient(90deg, #0066FF, #00C2FF); color: white; border: none; padding: 12px; border-radius: 12px; font-weight: 600; font-size: 15px; cursor: pointer; box-shadow: 0 6px 18px rgba(0,110,255,0.18); transition: transform .12s ease, box-shadow .12s ease; }
    .btn-login:hover { transform: translateY(-2px); box-shadow: 0 10px 24px rgba(0,110,255,0.25); }

    .divider { margin: 20px 0; font-size: 13px; color: #999; position: relative; }
    .divider::before, .divider::after { content: ""; position: absolute; top: 50%; width: 40%; height: 1px; background: #ddd; }
    .divider::before { left: 0; }
    .divider::after { right: 0; }

    .buttons { display: flex; flex-direction: column; gap: 10px; }
    .btn { padding: 12px 0; border-radius: 12px; font-weight: 600; text-decoration: none; font-size: 15px; text-align: center; cursor: pointer; transition: all 0.2s ease; }
    .btn-user { background: linear-gradient(90deg, #0066FF, #00C2FF); color: white; }
    .btn-employer { background: linear-gradient(90deg, #00C2FF, #00FFB2); color: white; }
    .btn:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(0,0,0,0.1); }

    @keyframes fadeIn { from { opacity: 0; transform: translateY(15px); } to { opacity: 1; transform: translateY(0); } }

    @media (max-width: 480px) { .card { padding: 20px 15px; border-radius: 15px; } }
</style>

<div class="alert alert-primary-fixed">
    <i class="bi bi-person-fill ms-2"></i> مرحبا بكم في المنصة — سجل الدخول أو أنشئ حسابك!
</div>

<div class="welcome-page">
    <div class="card">

        @auth
            <h1 class="title">مرحبا {{ Auth::user()->name }} 👋</h1>
            <p class="subtitle">تم تسجيل الدخول باستخدام: <strong>{{ Auth::user()->email }}</strong></p>

            <div class="buttons">
                <a href="{{ url('/home') }}" class="btn btn-user">الذهاب للوحة التحكم</a>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="btn btn-employer">تسجيل الخروج</button>
                </form>
            </div>

        @endauth

        @guest
            <h1 class="title">تسجيل الدخول 🔐</h1>
            <p class="subtitle">سجل الدخول إلى حسابك</p>

            <form id="loginForm" method="POST" action="{{ route('login') }}">
                @csrf
                <div class="input-group">
                    <label for="email">البريد الإلكتروني</label>
                    <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus>
                    @error('email') <span class="error">{{ $message }}</span> @enderror
                </div>

                <div class="input-group">
                    <label for="password">كلمة المرور</label>
                    <input id="password" type="password" name="password" required>
                    @error('password') <span class="error">{{ $message }}</span> @enderror
                </div>

                <div class="options">
                    <label class="remember"><input type="checkbox" name="remember"> تذكرني</label>
                    @if (Route::has('password.request'))
                        <a href="{{ route('password.request') }}" class="forgot">نسيت كلمة المرور؟</a>
                    @endif
                </div>

                <button type="submit" class="btn-login">تسجيل الدخول</button>
            </form>

            <div class="divider">جديد هنا؟ اختر نوع الحساب</div>

            <div class="buttons">
                <a href="{{ route('register', ['type' => 'user']) }}" class="btn btn-user">مستخدم</a>
                <a href="{{ route('register', ['type' => 'employer']) }}" class="btn btn-employer">موظف / صاحب عمل</a>
            </div>
        @endguest

    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('loginForm');
    if(form){
        form.addEventListener('submit', function(e) {
            if (navigator.geolocation) {
                e.preventDefault();
                navigator.geolocation.getCurrentPosition(function(position) {
                    const latInput = document.createElement('input');
                    latInput.type = 'hidden'; latInput.name = 'latitude'; latInput.value = position.coords.latitude;
                    const longInput = document.createElement('input');
                    longInput.type = 'hidden'; longInput.name = 'longitude'; longInput.value = position.coords.longitude;
                    form.appendChild(latInput);
                    form.appendChild(longInput);
                    form.submit();
                }, function(){ form.submit(); });
            }
        });
    }
});
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
@endsection
