@extends('layouts.app')

@section('content')
<style>
/* Cache la navbar sur cette page */
nav.navbar {
    display: none !important;
}

/* Alert fixe en haut */
.alert-primary-fixed {
    position: fixed;
    top: 0; left: 0; right: 0;
    z-index: 1050;
    margin: 0; border-radius: 0; border: none;
    background-color: #007bff;
    color: white;
    display: flex; align-items: center; justify-content: center;
    font-weight: 600;
    height: 50px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    direction: rtl;
    text-align: center;
}

/* الصفحة الرئيسية */
.register-page {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    background: linear-gradient(135deg,#007bff,#00c6ff);
    padding: 16px;
    padding-top: 80px;
    direction: rtl;
    text-align: right;
}

/* الكارد */
.card {
    background: #fff;
    border-radius: 25px;
    padding: 40px 32px;
    max-width: 420px;
    width: 100%;
    box-shadow: 0 12px 30px rgba(0,0,0,0.15);
    text-align: right;
    direction: rtl;
}

/* الفورم */
.input-group { margin-bottom: 18px; text-align: right; }
.input-group label { font-weight: 600; display: block; margin-bottom: 6px; }
.input-group input, .input-group select {
    width: 100%; padding: 12px 14px; border: 1px solid #ddd; border-radius: 10px;
}

/* الزر */
.btn-register {
    width: 100%; padding: 14px; border: none; border-radius: 12px;
    background: linear-gradient(90deg,#0066FF,#00C2FF);
    color: #fff; font-weight: 600; cursor: pointer;
}

.error { color: red; font-size: 13px; }
.login-link { margin-top: 12px; }
</style>

<div class="alert alert-primary-fixed">
    <i class="bi bi-person-plus-fill ms-2"></i> أنشئ حسابك الآن!
</div>

<div class="register-page">
    <div class="card">
        <h1 class="title">إنشاء حساب 📝</h1>

        @php
            $type = request()->get('type', 'user');
        @endphp

        <p class="subtitle">
            {{ $type == 'employer' ? "تسجيل صاحب العمل" : "تسجيل مستخدم" }}
        </p>

        <form method="POST" action="{{ route('register') }}">
            @csrf
            <input type="hidden" name="type" value="{{ $type }}">
            <input type="hidden" name="latitude" id="latitude">
            <input type="hidden" name="longitude" id="longitude">

            <div class="input-group">
                <label for="name">الاسم الكامل</label>
                <input id="name" type="text" name="name" value="{{ old('name') }}" required autofocus>
                @error('name') <span class="error">{{ $message }}</span> @enderror
            </div>

            <div class="input-group">
                <label for="email">البريد الإلكتروني</label>
                <input id="email" type="email" name="email" value="{{ old('email') }}" required>
                @error('email') <span class="error">{{ $message }}</span> @enderror
            </div>

            <div class="input-group">
                <label for="password">كلمة المرور</label>
                <input id="password" type="password" name="password" required>
                @error('password') <span class="error">{{ $message }}</span> @enderror
            </div>

            <div class="input-group">
                <label for="password_confirmation">تأكيد كلمة المرور</label>
                <input id="password_confirmation" type="password" name="password_confirmation" required>
            </div>

            <div class="input-group">
                <label for="telephone">الهاتف</label>
                <input id="telephone" type="text" name="telephone" value="{{ old('telephone') }}" required>
                @error('telephone') <span class="error">{{ $message }}</span> @enderror
            </div>

            @if($type == 'employer')
                <div class="input-group">
                    <label for="category_id">الفئة</label>
                    <select name="category_id" required>
                        <option value="">اختر</option>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}" {{ old('category_id') == $cat->id ? 'selected' : '' }}>
                                {{ $cat->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('category_id') <span class="error">{{ $message }}</span> @enderror
                </div>

                <div class="input-group">
                    <label for="ville_id">المدينة</label>
                    <select name="ville_id" required>
                        <option value="">اختر</option>
                        @foreach($villes as $ville)
                            <option value="{{ $ville->id }}" {{ old('ville_id') == $ville->id ? 'selected' : '' }}>
                                {{ $ville->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('ville_id') <span class="error">{{ $message }}</span> @enderror
                </div>
            @endif

            <button type="submit" class="btn-register">تسجيل</button>

            <div class="login-link">
                <p>هل لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a></p>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            document.getElementById('latitude').value = position.coords.latitude;
            document.getElementById('longitude').value = position.coords.longitude;
        });
    }
});
</script>
@endsection
