@extends('layouts.app')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Categories</h2>
        <a href="{{ route('categories.create') }}" class="btn btn-success">New Category1</a>
    </div>

    <div class="row">
        @foreach($categories as $cat)
            <div class="col-md-4 mb-4">
                <div class="card h-100 text-center">
                    @if($cat->img)
                        <img style="width: 100%; height:150px; object-fit: cover;" src="{{ asset($cat->img) }}" class="card-img-top" alt="{{ $cat->name }}">
                    @endif
                    <div class="card-body">
                        <h5 class="card-title">{{ $cat->name }}</h5>
                        <a href="{{ route('categories.employees', $cat->id) }}" class="btn btn-primary mt-2">Voir les employés</a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection
