@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Add Category</h2>
    <a href="{{ route('categories.cat') }}" class="btn btn-secondary mb-3">Back</a>

    <form action="{{ route('categories.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-3">
            <label for="name" class="form-label">Category Name</label>
            <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required>
            @error('name')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        <div class="mb-3">
            <label for="img" class="form-label">Category Image</label>
            <input type="file" class="form-control @error('img') is-invalid @enderror" name="img">
            @error('img')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        <button type="submit" class="btn btn-success">Save</button>
    </form>
</div>
@endsection

