@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Edit Category</h2>
    <a href="{{ route('categories.index') }}" class="btn btn-secondary mb-3">Back</a>

    <form action="{{ route('categories.update', $category->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="name" class="form-label">Category Name</label>
            <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name', $category->name) }}" required>
            @error('name')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        <div class="mb-3">
            <label for="img" class="form-label">Category Image</label>
            @if($category->img)
                <div class="mb-2">
                    <img src="{{ asset($category->img) }}" alt="{{ $category->name }}" width="100">
                </div>
            @endif
            <input type="file" class="form-control @error('img') is-invalid @enderror" name="img">
            @error('img')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary">Update</button>
    </form>
</div>
@endsection
