@extends('layouts.app')

{{-- Définir variable pour cacher le navbar --}}
@php $hideNavbar = true; @endphp

@section('content')
<div class="container" dir="rtl" style="padding-top: 120px; background: #fefefe; min-height:100vh; text-align:right;">

    {{-- Alert fixe en haut --}}
    <div class="alert alert-primary text-center position-fixed top-0 start-0 end-0 m-0 rounded-0" style="z-index:1050; direction:rtl;">
        <h4 class="mb-0 fw-bold">المستخدمين في الفئة: {{ $category->name }}</h4>
    </div>

    {{-- Recherche par ville --}}
    <div class="mt-4 mb-4 text-center" style="direction:rtl;">
        <form action="{{ route('employees.search.by.city', $category->id) }}" method="GET" class="d-inline-flex gap-2">
            <select name="city_id" class="form-select" required>
                <option value="">-- اختر المدينة --</option>
                @foreach($cities as $city)
                    <option value="{{ $city->id }}" @if(request('city_id') == $city->id) selected @endif>{{ $city->name }}</option>
                @endforeach
            </select>
            <button type="submit" class="btn btn-primary">بحث</button>
        </form>
    </div>

    {{-- Message d'erreur --}}
    @if(session('error'))
        <div class="alert alert-danger mt-3 text-center fw-bold">
            {{ session('error') }}
        </div>
    @endif

    {{-- Résultats --}}
    @if($employers->isEmpty())
        <div class="alert alert-warning mt-3 text-center fw-bold">
            ما كاين حتى مقدم خدمة فهاد الفئة فهاد المدينة أو بالقرب منك.
        </div>
    @else
        <div class="row mt-3" style="direction:rtl;">
            @foreach($employers as $emp)
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="card-title fw-bold">{{ $emp->name }}</h5>

                                @isset($emp->distance)
                                    <small class="text-muted">{{ number_format($emp->distance,2) }} كلم منك</small>
                                @else
                                    <small class="text-muted">المدينة: {{ $emp->city->name ?? 'غير معروف' }}</small>
                                @endisset
                            </div>
                            <a href="{{ route('employees.show', $emp->id) }}" class="btn btn-info">
                                <i class="bi bi-eye ms-1"></i> التفاصيل
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>

{{-- Footer fixe --}}
<footer class="d-flex justify-content-around align-items-center" 
        style="direction:rtl; position: fixed; bottom:0; left:0; right:0; height:60px; background:#f8f9fa; border-top:1px solid #ddd; z-index:1050;">
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">الرئيسية</span>
    </a>

    @php
        $dashboardUrl = url('/home');
        if(Auth::check()) {
            if(Auth::user()->is_admin) {
                $dashboardUrl = route('admin.dashboard');
            } elseif(Auth::user()->is_employer) {
                $dashboardUrl = route('employer.dashboard');
            } else {
                $dashboardUrl = route('user.dashboard');
            }
        }
    @endphp

    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">لوحة التحكم</span>
    </a>
</footer>

{{-- Bootstrap Icons --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { margin:0; background:#fefefe; font-family: "Tajawal", sans-serif; }
.card { border-radius:15px; transition: transform 0.2s; text-align:right; }
.card:hover { transform: translateY(-3px); box-shadow:0 12px 25px rgba(0,0,0,0.15); }
.alert { font-weight:600; }
.form-select, .btn { font-weight:bold; }
</style>
@endsection
