@extends('layouts.app')

@section('content')
{{-- Alert success fixe en haut --}}
@if(Auth::check())
    <div class="alert alert-success text-center position-fixed top-0 start-0 end-0 m-0 rounded-0 fw-bold" style="z-index: 1050; direction: rtl; font-size: 1.1rem;">
        مرحباً، {{ Auth::user()->name }}
    </div>
@endif

<div class="container py-4" style="padding-top: 100px; direction: rtl; text-align: right; font-weight: bold; font-size: 1.1rem;">

    {{-- 🔥 Bouton Portfolio --}}
    @php
        $user = Auth::user();
        $hasPortfolio = $user && $user->portfolio()->exists();
    @endphp
<div class="mb-4 text-end">
    {{-- رابط إضافة خدمة --}}
    <a href="{{ route('services.create') }}" class="btn btn-primary fw-bold">
        <i class="bi bi-plus-circle ms-1"></i>
        أضف متجرك
    </a>
</div>
    <div class="mb-4 text-end">
        @if(!$hasPortfolio)
            <a href="{{ route('portfolio.create') }}" class="btn btn-danger fw-bold">
                <i class="bi bi-plus-circle ms-1"></i>
                أضف محفظتك
            </a>
        @else
            <a href="{{ route('employees.show', $user->id) }}" class="btn btn-success fw-bold">
                <i class="bi bi-eye ms-1"></i>
                عرض محفظتك
            </a>
        @endif
    </div>

    <h2 class="mb-4 fw-bold">تنبيهاتك</h2>

    @if($alerts->isEmpty())
        <div class="alert alert-info fw-bold">لا توجد أي تنبيهات حتى الآن.</div>
    @else
        <div class="list-group">
            @foreach($alerts as $alert)
                @php
                    $cardClass = match($alert->statut_id) {
                        1 => 'list-group-item-primary',
                        3 => 'list-group-item-success',
                        default => 'list-group-item-light'
                    };
                    $statutText = match($alert->statut_id) {
                        1 => 'بانتظار الموافقة',
                        2 => 'قيد التنفيذ',
                        3 => 'تم القبول',
                        default => 'غير معروف'
                    };
                    $userProposition = $alert->propositions->where('employer_id', Auth::id())->first();
                @endphp

                <div class="list-group-item {{ $cardClass }} mb-3 rounded shadow-sm" style="font-weight: bold; font-size: 1.1rem;">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <h5 class="fw-bold">{{ Str::limit($alert->description, 50) }}</h5>
                            <small class="fw-bold">السعر المقترح: {{ $alert->prix_propose ?? '—' }} درهم</small><br>
                            <small class="fw-bold">الحالة: {{ $statutText }}</small>
                        </div>
                        <button class="btn btn-sm btn-info fw-bold" data-bs-toggle="modal" data-bs-target="#mapModal{{ $alert->id }}">
                            الموقع
                        </button>
                    </div>

                    @if($userProposition)
                        <div class="alert alert-success py-2 px-3 mb-3 fw-bold">
                            💬 لقد قدمت عرضاً بقيمة <strong>{{ $userProposition->prix }} درهم</strong>.
                        </div>
                    @elseif(!$alert->accepted_employer_id)
                        <form method="POST" action="{{ route('propositions.store', $alert->id) }}" class="d-flex gap-2 mb-3">
                            @csrf
                            <input type="hidden" name="alert_id" value="{{ $alert->id }}">
                            <input type="number" name="prix" class="form-control fw-bold" placeholder="عرضك (درهم)" required>
                            <button type="submit" class="btn btn-primary fw-bold">إرسال</button>
                        </form>
                    @endif

                    @if($alert->propositions->isNotEmpty())
                        <h6 class="fw-bold">العروض:</h6>
                        <ul class="list-group">
                            @foreach($alert->propositions as $prop)
                                <li class="list-group-item d-flex justify-content-between align-items-center fw-bold">
                                    {{ $prop->employer->name ?? 'مقدم الخدمة' }} — <strong>{{ $prop->prix }} درهم</strong>
                                    @if($alert->accepted_employer_id == $prop->employer_id)
                                        <span class="badge bg-success">✅ تم القبول</span>
                                    @elseif($alert->statut_id == 2)
                                        <span class="badge bg-warning text-dark">بانتظار</span>
                                    @else
                                        <span class="badge bg-secondary">رفض</span>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>

                {{-- Modal carte --}}
                <div class="modal fade" id="mapModal{{ $alert->id }}" tabindex="-1" aria-labelledby="mapModalLabel{{ $alert->id }}" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content" style="direction: rtl;">
                      <div class="modal-header">
                        <h5 class="modal-title fw-bold" id="mapModalLabel{{ $alert->id }}">الموقع</h5>
                        <button type="button" class="btn-close"></button>
                      </div>
                      <div class="modal-body p-0">
                        <div id="modalMap{{ $alert->id }}" style="height: 600px; width: 100%;"></div>
                      </div>
                      <div class="modal-footer d-flex justify-content-between">
                        <span class="text-primary fw-bold" id="distance{{ $alert->id }}"></span>
                        <a id="wazeBtn{{ $alert->id }}" href="#" target="_blank" class="btn btn-success fw-bold" style="display:none;">
                            <i class="bi bi-compass"></i> تتبع على Waze
                        </a>
                        <button type="button" class="btn btn-secondary fw-bold" data-bs-dismiss="modal">إغلاق</button>
                      </div>
                    </div>
                  </div>
                </div>
            @endforeach
        </div>
    @endif
</div>

{{-- Leaflet --}}
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    @foreach($alerts as $alert)
        let map{{ $alert->id }};

        document.querySelector('#mapModal{{ $alert->id }}').addEventListener('shown.bs.modal', function () {
            if (!map{{ $alert->id }}) {
                const clientLat = {{ $alert->latitude ?? 0 }};
                const clientLng = {{ $alert->longitude ?? 0 }};
                const userLat = {{ auth()->user()->latitude ?? 0 }};
                const userLng = {{ auth()->user()->longitude ?? 0 }};

                map{{ $alert->id }} = L.map('modalMap{{ $alert->id }}').setView([userLat, userLng], 13);

                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19,
                    attribution: '&copy; OpenStreetMap'
                }).addTo(map{{ $alert->id }});

                const clientMarker = L.marker([clientLat, clientLng]).addTo(map{{ $alert->id }}).bindPopup("العميل");
                const userMarker = L.marker([userLat, userLng]).addTo(map{{ $alert->id }}).bindPopup("أنت");

                const line = L.polyline([[userLat, userLng], [clientLat, clientLng]], {color:'blue'}).addTo(map{{ $alert->id }});

                const R = 6371;
                const dLat = (clientLat-userLat)*(Math.PI/180);
                const dLng = (clientLng-userLng)*(Math.PI/180);
                const a = Math.sin(dLat/2)**2 + Math.cos(userLat*(Math.PI/180))*Math.cos(clientLat*(Math.PI/180))*Math.sin(dLng/2)**2;
                const c = 2*Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
                const distance = R * c;
                document.getElementById('distance{{ $alert->id }}').innerText = distance.toFixed(2) + " كم";

                if (/Mobi|Android/i.test(navigator.userAgent)) {
                    const wazeBtn = document.getElementById('wazeBtn{{ $alert->id }}');
                    wazeBtn.href = `https://waze.com/ul?ll=${clientLat},${clientLng}&navigate=yes`;
                    wazeBtn.style.display = 'inline-block';
                }
            } else {
                map{{ $alert->id }}.invalidateSize();
            }
        });
    @endforeach
});
</script>

{{-- Masquer navbar --}}
<style>
.navbar { display: none !important; }
body { padding-top: 100px; font-weight: bold; font-size: 1.1rem; direction: rtl; text-align: right; }
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
@endsection
