@extends('layouts.app')

@section('content')
<style>
  body {
      background: #fff; /* الخلفية بيضاء */
  }

  /* تكبير العنوان الرئيسي وجعله غامق */
  .alert.alert-primary strong {
      font-size: 1.5rem;
      font-weight: 700; /* غامق */
  }

  /* تكبير النصوص داخل الطلبات وجعلها غامقة */
  .fw-bold {
      font-size: 1.2rem;
      font-weight: 700;
  }

  /* النصوص الصغيرة داخل الطلبات غامقة قليلًا */
  small.text-muted {
      font-size: 0.95rem;
      font-weight: 600;
  }

  /* تكبير الأزرار داخل العروض وجعل النص غامق */
  .btn-sm {
      font-size: 0.95rem;
      font-weight: 700;
  }

  /* تكبير كل الفقرات داخل الطلبات وجعلها غامقة */
  .mb-3 p, .mb-3 span {
      font-weight: 600;
  }

  /* خلفية الحاوية بيضاء */
  .container.py-4 {
      background: #fff;
  }
</style>

<div class="container py-4" dir="rtl" style="padding-top: 100px; text-align: right; background: #fff;">

{{-- العنوان الثابت في الأعلى --}}
<div class="alert alert-primary d-flex align-items-center justify-content-between" 
     style="direction: rtl; position: fixed; top: 0; right: 0; left: 0; z-index: 1050; margin: 0; border-radius: 0; padding: 0.75rem 1rem;">
    
    <div class="d-flex align-items-center">
        <i class="bi bi-bell-fill ms-2"></i>
        <strong>طلباتك للخدمات</strong>
    </div>

    <div class="d-flex align-items-center gap-2">
        <span class="badge bg-light text-dark">{{ $myAlerts->count() }} طلب(ات)</span>
        <a href="{{ route('alerts.create') }}" class="btn btn-light btn-sm">
            + طلب جديد
        </a>
    </div>
</div>

<div class="mt-4">
    @if($myAlerts->isEmpty())
        <div class="alert alert-info text-center">لم تقم بعد بإرسال أي طلب.</div>
    @else
        @foreach($myAlerts as $alert)
            <div class="mb-3 p-3 border rounded shadow-sm" style="direction: rtl; background:#fff;">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="fw-bold">{{ $alert->category->name ?? 'بدون فئة' }}</span>
                    @if($alert->propositions->isNotEmpty())
                        <span class="badge bg-info text-dark">{{ $alert->propositions->count() }} عرض(عروض)</span>
                    @endif
                </div>

                <p style="font-weight: 600;">{{ Str::limit($alert->description, 100) }}</p>

                @if($alert->photo)
                    <img src="{{ asset('storage/' . $alert->photo) }}" class="img-fluid mb-2" style="max-height:150px; object-fit:cover;">
                @endif

                <small class="text-muted">السعر المقترح: {{ $alert->prix_propose ?? '—' }} درهم</small><br>
                <small class="text-muted">التاريخ: {{ $alert->date_demande ?? '—' }} | الساعة: {{ $alert->heure_demande ?? '—' }}</small>
                
                {{-- العروض --}}
                @if($alert->propositions->isNotEmpty())
                    <div class="mt-2">
                        @foreach($alert->propositions as $prop)
                            <div class="d-flex justify-content-between align-items-center mb-2 p-2 border rounded" style="direction: rtl; background:#fff;">
                                <span style="font-weight: 600;">من طرف: {{ $prop->employer->name ?? '—' }} - السعر: {{ $prop->prix }} درهم</span>
                                <div>
                                    @if(!$alert->accepted_employer_id)
                                        <form action="{{ route('propositions.choose', $prop->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-success btn-sm">قبول</button>
                                        </form>
                                    @else
                                        @if($alert->accepted_employer_id == $prop->employer_id)
                                            <span class="badge bg-success">✅ تم الاختيار</span>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-muted mt-2">لا يوجد أي عرض لهذا الطلب حالياً.</p>
                @endif
            </div>
        @endforeach
    @endif
</div>
</div>

{{-- تذييل ثابت --}}
<footer style="direction: rtl; position: fixed; bottom: 0; right: 0; left: 0; height: 60px; background: #f8f9fa; display: flex; justify-content: space-around; align-items: center; border-top: 1px solid #ddd; z-index: 1050;">
    
    {{-- زر الصفحة الرئيسية --}}
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">الرئيسية</span>
    </a>

    @php
        $dashboardUrl = url('/home');

        if (Auth::check()) {
            $user = Auth::user();

            if ($user->hasRole('admin')) {
                $dashboardUrl = url('/dashboard');
            } elseif ($user->hasRole('employer')) {
                $dashboardUrl = url('/dashboard-employer');
            } elseif ($user->hasRole('user')) {
                $dashboardUrl = url('/dashboard-user');
            }
        }
    @endphp

    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">لوحة التحكم</span>
    </a>
</footer>

{{-- أيقونات Bootstrap --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

@endsection
