@extends('layouts.app')

@section('content')
<div class="container" style="padding-top: 80px;"> {{-- espace pour titre fixe --}}
    
    {{-- Titre fixe dans alert --}}
    <div class="alert alert-primary d-flex justify-content-between align-items-center" 
         style="position: fixed; top: 0; left: 0; right: 0; z-index: 1050; margin: 0; border-radius: 0;">
        <h4 class="mb-0">Employés</h4>
        @if(Auth::user()->is_admin)
            <a href="{{ route('employees.create') }}" class="btn btn-success btn-sm">+ Ajouter</a>
        @endif
    </div>

    @if($employees->isEmpty())
        <div class="alert alert-warning mt-4">
            Aucun employé trouvé.
        </div>
    @else
        <ul class="list-group mt-4">
            @foreach($employees as $emp)
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    {{-- Avatar --}}
                    <div class="me-3">
                        @if($emp->photo)
                            <img src="{{ asset('storage/' . $emp->photo) }}" class="rounded-circle" style="width:50px; height:50px; object-fit:cover;">
                        @else
                            <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width:50px; height:50px; font-weight:bold;">
                                {{ strtoupper(substr($emp->name,0,1)) }}
                            </div>
                        @endif
                    </div>

                    {{-- Infos --}}
                    <div class="flex-grow-1">
                        <h5 class="mb-1">{{ $emp->name }}</h5>
                        <small>{{ $emp->email }}</small><br>
                        <small><strong>Catégorie:</strong> {{ $emp->category->name ?? '—' }} | 
                               <strong>Ville:</strong> {{ $emp->ville->name ?? '—' }}</small>
                    </div>

                    {{-- Boutons à droite --}}
                    <div class="d-flex align-items-center">
                        {{-- Détails --}}
                        <a href="{{ route('employees.show', $emp->id) }}" class="btn btn-info btn-sm rounded-circle me-2 d-flex align-items-center justify-content-center" style="width:35px; height:35px;">
                            <i class="bi bi-eye"></i>
                        </a>

                        @if(Auth::user()->is_admin)
                            {{-- Modifier --}}
                            <a href="{{ route('employees.edit', $emp->id) }}" class="btn btn-warning btn-sm rounded-circle me-2 d-flex align-items-center justify-content-center" style="width:35px; height:35px;">
                                <i class="bi bi-pencil"></i>
                            </a>
                            {{-- Supprimer --}}
                            <form action="{{ route('employees.destroy', $emp->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" onclick="return confirm('Supprimer ?')" class="btn btn-danger btn-sm rounded-circle d-flex align-items-center justify-content-center" style="width:35px; height:35px;">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        @endif
                    </div>
                </li>
            @endforeach
        </ul>
    @endif
</div>
@endsection
{{-- Footer fixe --}}
<footer style="position: fixed; bottom: 0; left: 0; right: 0; height: 60px; background: #f8f9fa; display: flex; justify-content: space-around; align-items: center; border-top: 1px solid #ddd; z-index: 1050;">
    
    {{-- Bouton Home --}}
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">Home</span>
    </a>

    {{-- Bouton Mon Dashboard --}}
    @php
        $dashboardUrl = url('/home'); // par défaut
        if(Auth::check()) {
            if(Auth::user()->is_admin) {
                $dashboardUrl = route('admin.dashboard');
            } elseif(Auth::user()->is_employer) {
                $dashboardUrl = route('employer.dashboard');
            } else {
                $dashboardUrl = route('user.dashboard');
            }
        }
    @endphp

    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">Mon Dashboard</span>
    </a>
</footer>

{{-- Bootstrap Icons --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
