@extends('layouts.app')

@section('content')
<div class="container" style="padding-top: 80px;">
    <h3>Employeurs dans la catégorie: {{ $category->name }}</h3>

    @if($employers->isEmpty())
        <div class="alert alert-warning">Aucun employeur proche trouvé pour cette catégorie.</div>
    @else
        <ul class="list-group mt-3">
            @foreach($employers as $emp)
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <strong>{{ $emp->name }}</strong><br>
                        <small>{{ $emp->email }}</small><br>
                        <small>{{ number_format($emp->distance, 2) }} km de vous</small>
                    </div>
                    <a href="{{ route('employees.show', $emp->id) }}" class="btn btn-info btn-sm">Voir</a>
                </li>
            @endforeach
        </ul>
    @endif
</div>
@endsection
