@extends('layouts.app')

{{-- Cacher le navbar --}}
@php $hideNavbar = true; @endphp

@section('content')
<div class="container" dir="rtl" style="padding-top: 120px; padding-bottom: 80px; text-align:right; min-height:100vh; background:#fefefe;">

    {{-- Alert fixe en haut avec le nom du Hrafi --}}
    <div class="alert alert-primary text-center position-fixed top-0 start-0 end-0 m-0 rounded-0" style="z-index:1050; direction:rtl;">
        <h4 class="mb-0 fw-bold">معلومات الحرفي: {{ $employer->name }}</h4>
    </div>

    {{-- Infos du Hrafi --}}
    <div class="card shadow-sm mb-4 mt-3">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-2">
                    <p><strong>الهاتف :</strong> {{ $employer->telephone ?? 'غير متوفر' }}</p>
                    <p><strong>العنوان :</strong> {{ $employer->adresse ?? 'غير محدد' }}</p>
                </div>
                <div class="col-md-6 mb-2">
                    <p><strong>المدينة :</strong> {{ $employer->ville->name ?? '—' }}</p>
                </div>
            </div>

            {{-- Button Services --}}
            <div class="text-end mt-3">
                @if($employer->services && $employer->services->count() > 0)
                    <a href="{{ route('services.show', $employer->id) }}" class="btn btn-primary fw-bold">
                        <i class="bi bi-shop me-1"></i> شاهد خدمات هذا الحرفي
                    </a>
                @else
                    <button class="btn btn-secondary fw-bold" disabled>
                        <i class="bi bi-shop me-1"></i> لا توجد خدمات
                    </button>
                @endif
            </div>
        </div>
    </div>

    {{-- Portfolio --}}
    @if($employer->portfolio)
        <h5 class="fw-bold mb-3">أعمال سابقة / Portfolio</h5>
        <div class="row g-3">
            @foreach(['work_image1','work_image2','work_image3','work_image4','work_image5','work_image6'] as $imgField)
                @if($employer->portfolio->$imgField)
                    <div class="col-6 col-md-3">
                        <div class="card shadow-sm">
                            <img src="{{ asset($employer->portfolio->$imgField) }}" class="card-img-top" style="height:150px; object-fit:cover;">
                            <div class="card-body text-center p-2">
                                <small>تقييم : {{ $employer->portfolio->note }}</small>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    @else
        <p class="text-muted mt-3 fw-bold">هذا الموظف لم يقم بعد بإضافة Portfolio.</p>
    @endif

    {{-- Formulaire Avis --}}
    <div class="card shadow-sm p-3 mt-4">
        <h5 class="fw-bold mb-3">شارك برأيك عن هذا الحرفي</h5>
        @if(Auth::check())
            <form action="{{ route('opinions.store', $employer->id) }}" method="POST">
                @csrf
                <div class="row mb-2">
                    <div class="col-md-3">
                        <label class="fw-bold">تقييم (1-5)</label>
                        <select name="note" class="form-control" required>
                            @for($i=1; $i<=5; $i++)
                                <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-9">
                        <label class="fw-bold">رأيك</label>
                        <textarea name="content" class="form-control" rows="2" placeholder="أكتب رأيك هنا..." required></textarea>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary fw-bold">إرسال الرأي</button>
            </form>
        @else
            <p class="text-muted">يجب تسجيل الدخول لإضافة رأيك.</p>
        @endif
    </div>

    {{-- Afficher les Opinions --}}
    <div class="mt-4">
        <h5 class="fw-bold mb-3">آراء المستخدمين</h5>
        @if($employer->opinions && $employer->opinions->count() > 0)
            <div class="row g-3">
                @foreach($employer->opinions as $opinion)
                    <div class="col-12 col-md-6">
                        <div class="card shadow-sm p-3 h-100">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong>{{ $opinion->user->name ?? 'مستخدم' }}</strong>
                                <span class="text-warning">⭐{{ $opinion->note }}</span>
                            </div>
                            <p>{{ $opinion->content }}</p>
                            <small class="text-muted">{{ $opinion->created_at->diffForHumans() }}</small>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-muted fw-bold">لا توجد آراء بعد.</p>
        @endif
    </div>

</div>

{{-- Footer fixe --}}
<footer class="d-flex justify-content-around align-items-center" 
        style="direction:rtl; position: fixed; bottom:0; left:0; right:0; height:60px; background:#f8f9fa; border-top:1px solid #ddd; z-index:1050;">
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">الرئيسية</span>
    </a>

    @php
        $dashboardUrl = url('/home');
        if(Auth::check()) {
            if(Auth::user()->is_admin) {
                $dashboardUrl = route('admin.dashboard');
            } elseif(Auth::user()->is_employer) {
                $dashboardUrl = route('employer.dashboard');
            } else {
                $dashboardUrl = route('user.dashboard');
            }
        }
    @endphp

    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">لوحة التحكم</span>
    </a>
</footer>

{{-- Bootstrap Icons --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { margin:0; font-family: "Tajawal", sans-serif; background:#fefefe; }
.card { border-radius:15px; transition: transform 0.2s; text-align:right; }
.card:hover { transform: translateY(-3px); box-shadow:0 12px 25px rgba(0,0,0,0.15); }
.form-select, .btn { font-weight:bold; }
.alert { font-weight:600; }
</style>
@endsection
