@extends('layouts.app')

@section('content')
<style>
    /* 🌈 خلفية متدرجة أنيقة */
    body {
        background: linear-gradient(135deg, #e0e7ff 0%, #f9fafb 100%);
    }

    /* Animation بسيطة عند الظهور */
    .fade-in {
        animation: fadeIn 1s ease-in-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* الزر */
    .btn-main {
        background: linear-gradient(90deg, #007bff, #00bcd4);
        border: none;
        transition: 0.4s ease;
        color: white;
        font-weight: bold;
        letter-spacing: 0.5px;
    }
    .btn-main:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    }

    /* كارت المحتوى */
    .card-landing {
        background: white;
        border: none;
        border-radius: 1.5rem;
        box-shadow: 0 8px 30px rgba(0,0,0,0.08);
    }

    /* Responsive title */
    h1 {
        font-size: clamp(1.8rem, 4vw, 2.5rem);
        font-weight: 800;
        color: #1e293b;
    }

    p, li {
        color: #334155;
        line-height: 1.6;
    }
</style>

<div class="container py-5 fade-in">
    {{-- الصورة --}}
    <div class="text-center mb-4">
        <img src="{{ asset('img/1.png') }}" alt="خدمة قريبة منك" 
             class="img-fluid rounded-4 shadow" 
             style="max-height: 320px; object-fit: cover;">
    </div>

    {{-- العنوان الرئيسي --}}
    <h1 class="text-center mb-4">🧭 خدمة قريبة منك… بثمن يناسبك!</h1>

    {{-- الكارت --}}
    <div class="card card-landing p-4 mx-auto" style="max-width: 900px;">
        <p class="fs-5 text-center mb-4">
            فـ منصتنا الذكية، ما بقاتش الخدمة عشوائية 👇<br>
            دخُل، شوف الخريطة 📍، وتعرّف بالضبط فين كاينين وبشحال بعادين عليك بالمسافة الحقيقية 🚗.
        </p>

        <div class="row mt-4">
            <div class="col-md-6 mb-4 mb-md-0">
                <h5 class="fw-bold text-primary">🔹 الزبون يقدر:</h5>
                <ul>
                    <li>يحط طلبو مع التفاصيل والثمن اللي باغي.</li>
                    <li>يشوف الناس اللي قريبين منو على الخريطة.</li>
                    <li>يختار الحِرَفي أو المطوّر اللي يعجبو، ويشوف تقييماتو وثمنو.</li>
                </ul>
            </div>

            <div class="col-md-6">
                <h5 class="fw-bold text-primary">🔹 والحِرَفي / المطوّر يقدر:</h5>
                <ul>
                    <li>يشوف الطلبات القريبة منو.</li>
                    <li>يختار منها اللي تناسبو.</li>
                    <li>يحط ثمن يناسبو باش يزيد فرصو ويكسب عملاء أكثر.</li>
                </ul>
            </div>
        </div>

        <hr class="my-4">

        <p class="fs-5 text-center mt-3">
            🌍 المنصة كتخدم بالذكاء والموقع الجغرافي، باش كل واحد يلقى اللي محتاجو بسهولة وبدون تضييع الوقت.
        </p>

        <div class="text-center mt-4">
            <a href="{{ route('register.employer') }}" class="btn btn-main btn-lg rounded-pill px-5 py-3">
                سجّل دابا وخلي الناس يشوفوك على الخريطة! 🚀
            </a>
        </div>
    </div>
</div>
@endsection
