<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Talabia</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>
<body dir="rtl" style="font-family: 'Tajawal', sans-serif;">

    <div id="app" style="padding-bottom: 70px;"> {{-- مساحة للـ footer --}}

        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="{{ url('/') }}">
                    {{ config('app.name', 'Talabia') }}
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- جهة اليمين للـ Navbar -->
                    <ul class="navbar-nav me-auto"></ul>

                    <!-- جهة اليسار للـ Navbar -->
                    <ul class="navbar-nav ms-auto">
                        @guest
                            @if (Route::has('login'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('login') }}">تسجيل الدخول</a>
                                </li>
                            @endif

                            @if (Route::has('register'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('register') }}">إنشاء حساب</a>
                                </li>
                            @endif
                        @else
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                                   aria-haspopup="true" aria-expanded="false" v-pre>
                                    {{ Auth::user()->name }}
                                </a>

                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        تسجيل الخروج
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                        @endguest
                    </ul>
                </div>
            </div>
        </nav>

        <main class="py-4">
            @yield('content')
        </main>
    </div>

@if (!View::hasSection('no_footer'))
    {{-- Footer ثابت --}}
    <footer style="position: fixed; bottom: 0; left: 0; right: 0; height: 60px; background: #f8f9fa; display: flex; justify-content: space-around; align-items: center; border-top: 1px solid #ddd; z-index:1050;">
        
        {{-- زر الرئيسية --}}
        <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
            <i class="bi bi-house-fill fs-5"></i>
            <span class="small">الرئيسية</span>
        </a>

        {{-- زر لوحة التحكم --}}
        @php
            $dashboardUrl = url('/home');
            if (Auth::check()) {
                $user = Auth::user();
                if ($user->hasRole('admin')) {
                    $dashboardUrl = url('/dashboard');
                } elseif ($user->hasRole('employer')) {
                    $dashboardUrl = url('/dashboard-employer');
                } elseif ($user->hasRole('user')) {
                    $dashboardUrl = url('/dashboard-user');
                }
            }
        @endphp
        <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
            <i class="bi bi-person-circle fs-5"></i>
            <span class="small">لوحة التحكم</span>
        </a>

        {{-- زر تسجيل الخروج --}}
        @if(Auth::check())
        <a href="{{ route('logout') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center"
           onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
            <i class="bi bi-box-arrow-right fs-5"></i>
            <span class="small">الخروج</span>
        </a>
        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">@csrf</form>
        @endif
    </footer>
@endif

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</body>
</html>
