@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Ajouter Portfolio</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('portfolios.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        @for ($i = 1; $i <= 6; $i++)
            <div class="mb-3">
                <label for="work_image{{ $i }}">Image {{ $i }}</label>
                <input type="file" name="work_image{{ $i }}" id="work_image{{ $i }}" class="form-control">
            </div>
        @endfor

        <div class="mb-3">
            <label for="note">Note (0-10)</label>
            <input type="number" step="0.1" min="0" max="10" name="note" id="note" class="form-control" value="0">
        </div>

        <button type="submit" class="btn btn-primary">Ajouter Portfolio</button>
    </form>
</div>
@endsection
