@extends('layouts.app')

{{-- Cacher le navbar --}}
@php $hideNavbar = true; @endphp

@section('content')
<div class="container" dir="rtl" style="padding-top: 120px; padding-bottom: 80px; text-align:right; min-height:100vh; background:#fefefe;">

    {{-- Alert fixe en haut avec le nom du Hrafi --}}
    <div class="alert alert-primary text-center position-fixed top-0 start-0 end-0 m-0 rounded-0" style="z-index:1050; direction:rtl;">
        <h4 class="mb-0 fw-bold">إضافة خدمة جديدة</h4>
    </div>
  



    <form action="{{ route('services.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-3">
            <label>اسم الخدمة</label>
            <input type="text" name="title" class="form-control">
        </div>

        <div class="mb-3">
            <label>الوصف</label>
            <textarea name="description" class="form-control"></textarea>
        </div>

        <div class="mb-3">
            <label>الثمن</label>
            <input type="number" step="0.01" name="price" class="form-control">
        </div>

        <div class="mb-3">
            <label>الصورة (اختياري)</label>
            <input type="file" name="image" class="form-control">
        </div>

        <button class="btn btn-success">حفظ</button>

    </form>

</div>
@endsection
