@extends('layouts.app')

{{-- Cacher le navbar --}}
@php $hideNavbar = true; @endphp

@section('content')
<div class="container" dir="rtl" style="padding-top: 120px; padding-bottom: 80px; text-align:right; min-height:100vh; background:#fefefe;">

    {{-- Alert fixe en haut avec le nom du Hrafi --}}
    <div class="alert alert-primary text-center position-fixed top-0 start-0 end-0 m-0 rounded-0" style="z-index:1050; direction:rtl;">
        <h4 class="mb-0 fw-bold">تعديل الخدمة</h4>
    </div>
  



    <form action="{{ route('services.update', $service->id) }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-3">
            <label>اسم الخدمة</label>
            <input type="text" name="title" class="form-control" value="{{ $service->title }}" required>
        </div>

        <div class="mb-3">
            <label>الوصف</label>
            <textarea name="description" class="form-control">{{ $service->description }}</textarea>
        </div>

        <div class="mb-3">
            <label>الثمن</label>
            <input type="number" step="0.01" name="price" class="form-control" value="{{ $service->price }}" required>
        </div>

        <div class="mb-3">
            <label>الصورة (اختياري)</label>
            <input type="file" name="image" class="form-control">
            @if($service->image)
                <img src="{{ asset($service->image) }}" style="height:150px; object-fit:cover; margin-top:10px;">
            @endif
        </div>

        <button class="btn btn-success">حفظ التعديلات</button>

    </form>

</div>
@endsection
