@extends('layouts.app')

@section('content')
<div class="container">

    <a href="{{ route('services.create') }}" class="btn btn-primary mb-3">إضافة خدمة</a>

    <div class="row">
        @foreach($services as $service)
            <div class="col-md-4">
                <div class="card mb-3">

                    @if($service->image)
                        <img src="{{ asset('storage/'.$service->image) }}" class="card-img-top" style="height:200px;object-fit:cover;">
                    @endif

                    <div class="card-body">
                        <h5 class="card-title">{{ $service->title }}</h5>
                        <p>{{ $service->description }}</p>
                        <strong>{{ $service->price }} درهم</strong>

                        <div class="mt-2">
                            <a href="{{ route('services.edit', $service->id) }}" class="btn btn-warning btn-sm">تعديل</a>

                            <form action="{{ route('services.delete', $service->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger btn-sm">حذف</button>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
    </div>

</div>
@endsection
