@extends('layouts.app')

{{-- Cacher le navbar --}}
@php $hideNavbar = true; @endphp

@section('content')
<div class="container" dir="rtl" style="padding-top: 120px; padding-bottom: 80px; text-align:right; min-height:100vh; background:#fefefe;">

    {{-- Alert fixe en haut avec le nom du Hrafi --}}
    <div class="alert alert-primary text-center position-fixed top-0 start-0 end-0 m-0 rounded-0" style="z-index:1050; direction:rtl;">
        <h4 class="mb-0 fw-bold">خدمات {{ $user->name }}</h4>
    </div>
  

    <div class="row">
@forelse($services as $service)
    <div class="col-md-4">
        <div class="card mb-3">
            @if($service->image)
                <img src="{{ asset($service->image) }}" class="card-img-top" style="height:200px;object-fit:cover;">
            @endif

            <div class="card-body">
                <h5 class="card-title">{{ $service->title }}</h5>
                <p>{{ $service->description }}</p>
                <strong>{{ $service->price }} درهم</strong>

                @if(Auth::check() && Auth::id() == $service->user_id)
                    <div class="mt-3 d-flex justify-content-between">
                        <a href="{{ route('services.edit', $service->id) }}" class="btn btn-warning btn-sm fw-bold">تعديل</a>

                        <form action="{{ route('services.delete', $service->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm fw-bold">حذف</button>
                        </form>
                    </div>
                @endif

            </div>
        </div>
    </div>
@empty
    <p>لا توجد خدمات حتى الآن.</p>
@endforelse

    </div>

</div>
<footer style="direction: rtl; position: fixed; bottom: 0; right: 0; left: 0; height: 60px; background: #f8f9fa; display: flex; justify-content: space-around; align-items: center; border-top: 1px solid #ddd; z-index: 1050;">
    
    {{-- زر الصفحة الرئيسية --}}
    <a href="{{ url('/home') }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-house-fill fs-5"></i>
        <span class="small">الرئيسية</span>
    </a>

    @php
        $dashboardUrl = url('/home');

        if (Auth::check()) {
            $user = Auth::user();

            if ($user->hasRole('admin')) {
                $dashboardUrl = url('/dashboard');
            } elseif ($user->hasRole('employer')) {
                $dashboardUrl = url('/dashboard-employer');
            } elseif ($user->hasRole('user')) {
                $dashboardUrl = url('/dashboard-user');
            }
        }
    @endphp

    <a href="{{ $dashboardUrl }}" class="btn btn-light d-flex flex-column align-items-center justify-content-center">
        <i class="bi bi-person-circle fs-5"></i>
        <span class="small">لوحة التحكم</span>
    </a>
</footer>

{{-- أيقونات Bootstrap --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

@endsection
