@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h2 class="fw-bold text-primary mb-4">Liste des utilisateurs 👥</h2>

    <div class="card shadow-sm rounded-4">
        <div class="card-body p-0">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-primary text-center">
                    <tr>
                        <th>Nom</th>
                        <th>Email</th>
                        <th>Rôle</th>
                        <th>Catégorie</th>
                        <th>Ville</th>
                    </tr>
                </thead>
                <tbody class="text-center">
                    @foreach($users as $user)
                        <tr>
                            <td class="fw-semibold">{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>
                             @foreach($user->getRoleNames() as $role)
    <span class="badge 
        @if($role == 'admin') bg-danger 
        @elseif($role == 'employer') bg-success 
        @else bg-primary 
        @endif">
        {{ ucfirst($role) }}
    </span>
@endforeach
                            </td>
                            <td>
                                @if($user->hasRole('employer') && $user->category)
                                    {{ $user->category->name }}
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                @if($user->hasRole('employer') && $user->ville)
                                    {{ $user->ville->name }}
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.table {
    border-radius: 15px;
    overflow: hidden;
}
.table thead {
    background: linear-gradient(90deg, #007bff, #00c6ff);
    color: #fff;
}
.table tbody tr:hover {
    background-color: #f8f9fa;
}
.badge {
    font-size: 0.9rem;
    padding: 6px 10px;
}
</style>
@endsection
