@extends('layouts.app')

@section('content')
<div class="container" dir="rtl" style="padding-top: 70px; text-align: right;"> {{-- padding بسيط باش ميتغطاش بالهيدر --}}

    {{-- تنبيه ثابت في الأعلى --}}
    <div class="alert alert-primary d-flex align-items-center justify-content-between" role="alert" 
         style="direction: rtl; position: fixed; top: 0; right: 0; left: 0; z-index: 1050; width: 100%; margin: 0; border-radius: 0;">
        <div class="d-flex align-items-center">
            <i class="bi bi-tags-fill ms-2"></i>
            <strong>الفئات</strong>
        </div>
    </div>

    {{-- العنوان الرئيسي --}}
    <h2 class="text-center fw-bold mb-4" style="margin-top: 10px; font-size: 28px; color: #222;">
        اختار الخدمة اللي محتاج دابا 🔧
    </h2>
 <h1>عدد الزوار: {{ $number }}</h1>
    {{-- الكروت --}}
    <div class="row mt-2">
        @foreach($categories as $cat)
            <div class="col-6 col-lg-3 mb-4"> {{-- عنصران في الهاتف، أربعة في الشاشة الكبيرة --}}
                <div class="card h-100 text-center shadow-sm" style="direction: rtl; border-radius: 12px;">
                    @if($cat->img)
                        <img style="width: 100%; height:150px; object-fit: cover; border-top-left-radius: 12px; border-top-right-radius: 12px;" 
                             src="{{ asset($cat->img) }}" 
                             class="card-img-top" 
                             alt="{{ $cat->name }}">
                    @endif
                    <div class="card-body">
                        <h5 class="card-title fw-bold" style="color:#333;">{{ $cat->name }}</h5>
                        <a href="{{ route('categories.employees', $cat->id) }}" class="btn btn-primary mt-2 w-100">
                            <i class="bi bi-geo-alt-fill ms-1"></i> بالقرب منك
                        </a>
                        <a href="{{ route('alerts.create') }}" class="btn btn-success mt-2 w-100">
                            <i class="bi bi-bell-fill ms-1"></i> إنشاء تنبيه
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection

{{-- أيقونات Bootstrap --}}
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
