@extends('layouts.app')

@section('content')
<style>
/* نخفي Navbar */
nav.navbar {
    display: none !important;
}

/* باقي التنسيقات */
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: #f0f4f8;
    direction: rtl;
    text-align: right;
}

/* Alert فوق الفورم */
#loc-alert {
    background-color: #fee2e2;
    color: #991b1b;
    padding: 1rem;
    text-align: center;
    font-size: 1.2rem;
    font-weight: 600;
    border-radius: 0.5rem;
    margin-bottom: 20px;
    display: none;
}

/* نصوص الهبوط */
.landing-text h2 { font-size: 2.5rem; font-weight: 800; color: #1e293b; }
.landing-text p, .landing-text li { font-size: 1.3rem; color: #334155; }
.landing-text ul { padding-right: 25px; list-style-position: inside; }

/* كارت الفورم */
.card-form { border-radius: 1.5rem; box-shadow: 0 8px 25px rgba(0,0,0,0.08); }

/* الفورم inputs أكبر */
.form-control-lg, .form-select-lg { font-size: 1.1rem; padding: 0.7rem 1rem; }
.btn-lg { font-size: 1.3rem; padding: 0.8rem; }

/* الصورة responsive */
.hero-img { width: 100%; max-height: 350px; object-fit: cover; border-radius: 20px; }
</style>

<div class="container py-5 d-flex flex-column align-items-center" style="margin-top: 80px;">

    {{-- Alert --}}
    <div id="loc-alert">
        ⚠️ خاصك تفعل تحديد الموقع باش تكمل التسجيل.
    </div>

    {{-- الصورة + نص --}}
    <div class="text-center mb-4" style="max-width: 700px;">
        <img src="{{ asset('img/1.png') }}" class="hero-img shadow mb-3" alt="خدمتك قريبة">

        <div class="p-4 bg-white rounded-4 shadow landing-text">
            <h2 class="mb-3">خدمتك قريبة… والفرص كتسنّاك!</h2>
            <p class="mb-3">فمنصّتنا الذكية تشوف الطلبات اللي قريبين منك على الخريطة وتختار اللي يناسبك.</p>
            <ul class="mb-3">
                <li>زد فرصك وخدم أكثر</li>
                <li>حدّد الثمن اللي يناسبك</li>
                <li>خلّي الزبناء يشوفوك على الخريطة</li>
            </ul>
            <p class="fw-semibold">سجّل دابا وخدم بذكاء</p>
        </div>
    </div>

    {{-- الفورم --}}
    <div class="card shadow-lg card-form p-4" style="width: 100%; max-width: 500px;">
        <h3 class="text-center mb-4" style="font-size: 2rem;">تسجيل صاحب العمل</h3>

        <form method="POST" action="{{ route('register.employer') }}">
            @csrf
            <div class="mb-3">
                <label>الاسم الكامل</label>
                <input type="text" name="name" class="form-control form-control-lg" required value="{{ old('name') }}">
                @error('name') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control form-control-lg" required value="{{ old('email') }}">
                @error('email') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>الهاتف</label>
                <input type="text" name="telephone" class="form-control form-control-lg" required value="{{ old('telephone') }}">
                @error('telephone') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>فئة الخدمة</label>
                <select name="category_id" class="form-select form-select-lg" required>
                    <option value="">-- اختر الخدمة --</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" {{ old('category_id')==$cat->id?'selected':'' }}>
                            {{ $cat->name }}
                        </option>
                    @endforeach
                </select>
                @error('category_id') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>المدينة</label>
                <select name="ville_id" class="form-select form-select-lg" required>
                    <option value="">-- اختر المدينة --</option>
                    @foreach($villes as $v)
                        <option value="{{ $v->id }}" {{ old('ville_id')==$v->id?'selected':'' }}>
                            {{ $v->name }}
                        </option>
                    @endforeach
                </select>
                @error('ville_id') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>كلمة المرور</label>
                <input type="password" name="password" class="form-control form-control-lg" required>
                @error('password') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <div class="mb-3">
                <label>تأكيد كلمة المرور</label>
                <input type="password" name="password_confirmation" class="form-control form-control-lg" required>
            </div>

            <input type="hidden" name="latitude" id="latitude">
            <input type="hidden" name="longitude" id="longitude">

            <div class="d-grid mt-4">
                <button type="submit" class="btn btn-primary btn-lg">تسجيل</button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const alertBox = document.getElementById('loc-alert');
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition((pos) => {
            document.getElementById('latitude').value = pos.coords.latitude;
            document.getElementById('longitude').value = pos.coords.longitude;
        }, () => {
            alertBox.style.display = 'block';
        });
    } else {
        alertBox.style.display = 'block';
    }
});
</script>
@endsection
