@extends('layouts.app')

@section('content')
<div class="container">

    <a href="{{ route('caisse.create') }}" class="btn btn-primary mb-3">+ إضافة سجل كاش</a>

    <table class="table table-bordered">
        <tr>
            <th>مبلغ الصباح</th>
            <th>الزيادة</th>
            <th>المجموع النهائي</th>
            <th>التاريخ</th>
            <th>إجراءات</th>
        </tr>

        @foreach($caisses as $c)
        <tr>
            <td>{{ $c->montant_initial }} DH</td>
            <td>{{ $c->ajout }} DH</td>
            <td>{{ $c->total_du_jour }} DH</td>
            <td>{{ $c->date }}</td>
            <td>
                <a href="{{ route('caisse.edit', $c->id) }}" class="btn btn-warning btn-sm">تعديل</a>

                <form action="{{ route('caisse.destroy', $c->id) }}" method="POST" style="display:inline-block">
                    @csrf @method('DELETE')
                    <button class="btn btn-danger btn-sm">حذف</button>
                </form>
            </td>
        </tr>
        @endforeach
    </table>

</div>
@endsection
