@extends('layouts.app')

@section('content')

<div class="container">

<!-- 🔔 ALERTE -->
<div class="alert alert-primary d-flex justify-content-between align-items-center fw-bold fs-5 mb-4">

    <span>➕ Ajouter une dépense</span>

    @auth
        <a href="{{ asset('profile') }}" class="btn btn-light btn-sm fw-semibold shadow-sm">
            Mon Profil
        </a>
    @else
        <a href="{{ route('login') }}" class="btn btn-light btn-sm fw-semibold shadow-sm">
            Se connecter
        </a>
    @endauth

</div>


    <!-- 🧑‍💼 TITRE : Post + User -->
    <h1 class="text-center mb-4 fw-bold">
        {{ $post->titre }} — <span class="text-primary">{{ $user->name }}</span>
    </h1>

    <!-- 🧾 FORMULAIRE (8 colonnes) -->
    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="card shadow-sm p-4 rounded-3">

                <form action="{{ route('masarif.store') }}" method="POST">
                    @csrf

                    <!-- Hidden post_id -->
                    <input type="hidden" name="post_id" value="{{ $post->id }}">

                    <!-- Champ : Titre -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Titre</label>
                        <input type="text" name="titre" class="form-control" required>
                    </div>

                    <!-- Champ : Montant -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Montant</label>
                        <input type="number" name="montant" class="form-control" required>
                    </div>

                    <!-- Champ : Date -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Date</label>
                        <input type="date" name="date" class="form-control" required>
                    </div>

                    <!-- Champ : Observation -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Observation</label>
                        <textarea name="observation" class="form-control" rows="3"></textarea>
                    </div>

                    <!-- BOUTON -->
                    <div class="text-center mt-3">
                        <button class="btn btn-success px-5 fw-semibold">
                            Enregistrer
                        </button>
                    </div>

                </form>

            </div>

        </div>
    </div>

</div>

@endsection
