@extends('layouts.app')

@section('content')
<div class="container">

  <!-- 🔔 ALERT EN HAUT -->
<div class="alert alert-info d-flex justify-content-between align-items-center fw-bold fs-5 mb-4 shadow-sm">

    <span>📊 Liste des dépenses &amp; Filtre de recherche</span>

    @auth
        <a href="{{ asset('profile') }}" class="btn btn-light btn-sm fw-semibold shadow-sm">
            Mon Profil
        </a>
           <a href="{{ route('posts.index') }}" class="btn btn-info px-5 fw-semibold mt-2">
                            Voir les Posts
                        </a>
    @else
        <a href="{{ route('login') }}" class="btn btn-light btn-sm fw-semibold shadow-sm">
            Se connecter
        </a>
    @endauth

</div>


    <!-- 🔍 TITRE PAGE -->
    <h3 class="mb-4 text-center fw-bold text-primary">
        Liste des dépenses
    </h3>

    <!-- 🔎 FORMULAIRE DE RECHERCHE -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">

            <form action="{{ route('masarif.index') }}" method="GET" 
                  class="row g-3 align-items-end">

                <div class="col-md-3">
                    <label class="form-label">Période</label>
                    <select name="periode" id="periode" class="form-control">
                        <option value="">-- Sélectionner --</option>
                        <option value="aujourdhui" {{ request('periode')=='aujourdhui'?'selected':'' }}>Aujourd'hui</option>
                        <option value="cette_semaine" {{ request('periode')=='cette_semaine'?'selected':'' }}>Cette semaine</option>
                        <option value="ce_mois" {{ request('periode')=='ce_mois'?'selected':'' }}>Ce mois</option>
                        <option value="cette_annee" {{ request('periode')=='cette_annee'?'selected':'' }}>Cette année</option>
                        <option value="intervalle" {{ request('periode')=='intervalle'?'selected':'' }}>Par deux dates</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label">Date début</label>
                    <input type="date" name="date_debut" id="date_debut" 
                           class="form-control" value="{{ request('date_debut') }}">
                </div>

                <div class="col-md-3">
                    <label class="form-label">Date fin</label>
                    <input type="date" name="date_fin" id="date_fin" 
                           class="form-control" value="{{ request('date_fin') }}">
                </div>

                <div class="col-md-3 d-flex gap-2">
                    <button class="btn btn-primary flex-fill">Rechercher</button>
                    <a href="{{ route('masarif.index') }}" class="btn btn-secondary flex-fill">Réinitialiser</a>
                </div>
            </form>

        </div>
    </div>

    <!-- 💰 TOTAL -->
    <h5 class="fw-bold mb-3">
        Total Montant : <strong class="text-success">{{ $totalMontant }} DH</strong>
    </h5>

    <!-- 📋 TABLE DES DÉPENSES -->
    <div class="card shadow-sm">
        <div class="card-body p-0">

            <table class="table table-striped table-bordered mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>Titre</th>
                        <th>Montant</th>
                        <th>Date</th>
                        <th>Observation</th>
                        <th width="220">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($masarif as $m)
                    <tr>
                        <td>{{ $m->titre }}</td>
                        <td>{{ $m->montant }} DH</td>
                        <td>{{ $m->date }}</td>
                        <td>{{ $m->observation }}</td>
                        <td>
                            <a href="{{ route('masarif.show', $m->id) }}" class="btn btn-info btn-sm">Voir</a>
                            <a href="{{ route('masarif.edit', $m->id) }}" class="btn btn-warning btn-sm">Modifier</a>

                            <form action="{{ route('masarif.destroy', $m->id) }}" method="POST"
                                  style="display:inline-block">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger btn-sm"
                                        onclick="return confirm('Voulez-vous vraiment supprimer cette dépense ?')">
                                    Supprimer
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center py-3">Aucune dépense trouvée.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>

        </div>
    </div>

    <div class="d-flex justify-content-center mt-3">
        {{ $masarif->withQueryString()->links() }}
    </div>

</div>
@endsection
