@extends('layouts.app')

@section('content')

<div class="container">

    <!-- العنوان الرئيسي -->
    <div class="text-center mb-4">
        <h1 class="fw-bold">Profil : {{ $user->name }}</h1>
    </div>

    @foreach($posts as $post)
        <div class="card shadow-sm mb-4 p-3">

            <!-- عنوان البوست -->
            <h4 class="text-primary fw-semibold mb-3 text-center">
                {{ $post->titre }}
            </h4>

            <!-- الأزرار فالنص -->
            <div class="d-flex justify-content-center gap-3">

                <!-- Ajouter dépense -->
                <a href="{{ url('masarif/create/' . $post->id) }}"
                   class="btn btn-success px-4">
                    + Ajouter une dépense
                </a>

                <!-- Liste des dépenses -->
                <a href="{{ url('masarif') }}"
                   class="btn btn-outline-primary px-4">
                    Liste des dépenses
                </a>

            </div>

        </div>
    @endforeach

</div>

@endsection
