@extends('layouts.app')

@section('content')
<div class="container mt-4">

    <!-- ALERT TYPE INFO pour le titre avec bouton Accueil -->
    <div class="alert alert-info d-flex justify-content-between align-items-center" role="alert">
        <h4 class="mb-0">Gestion des Posts</h4>
        <a href="{{ url('/') }}" class="btn btn-sm btn-light">Accueil</a>
    </div>

    <!-- Formulaire ajout -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Ajouter un nouveau post</h5>
            <form action="{{ route('posts.store') }}" method="POST" class="row g-2">
                @csrf
                <div class="col-md-6">
                    <input type="text" name="titre" class="form-control" placeholder="Titre du post" required>
                </div>
                <div class="col-md-4">
                    <select name="user_id" class="form-select" required>
                        <option value="">Choisir un utilisateur</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">Ajouter</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Table posts -->
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title mb-3">Liste des posts</h5>
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Titre</th>
                        <th>Utilisateur</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($posts as $post)
                    <tr>
                        <td>{{ $post->id }}</td>
                        <td>
                            <form action="{{ route('posts.update', $post->id) }}" method="POST" class="d-flex gap-2">
                                @csrf
                                @method('PUT')
                                <input type="text" name="titre" value="{{ $post->titre }}" class="form-control" required>
                                <select name="user_id" class="form-select" required>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" @if($post->user_id == $user->id) selected @endif>
                                            {{ $user->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn btn-warning btn-sm">Modifier</button>
                            </form>
                        </td>
                        <td>{{ $post->user->name ?? 'Inconnu' }}</td>
                        <td>
                            <form action="{{ route('posts.destroy', $post->id) }}" method="POST" onsubmit="return confirm('Voulez-vous vraiment supprimer ce post ?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                    @if($posts->isEmpty())
                        <tr>
                            <td colspan="4" class="text-center text-muted">Aucun post trouvé</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
