@extends('layouts.app')

@section('content')

<div class="container">

    <!-- 🟦 CARTE PRINCIPALE -->
    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="card shadow-lg border-0 rounded-4">

                <!-- HEADER -->
                <div class="card-header bg-primary text-white text-center fw-bold fs-4">
                    Bienvenue dans l'espace de gestion des dépenses
                </div>

                <!-- BODY -->
                <div class="card-body text-center py-5">

                    <h2 class="fw-bold mb-3">
                        👋 Bonjour et bienvenue !
                    </h2>

                    <p class="text-muted fs-5 mb-4">
                        Ici vous pouvez gérer vos dépenses, consulter vos listings,
                        et suivre vos opérations financières facilement.
                    </p>

                    <!-- 🔐 Vérifier si user est connecté -->
                    @auth
                        <a href="{{ asset('profile') }}" class="btn btn-success px-5 fw-semibold mb-2">
                            Accéder à mon profil
                        </a>
                        <br>
                        <!-- Nouveau lien vers posts -->
                        <a href="{{ route('posts.index') }}" class="btn btn-info px-5 fw-semibold mt-2">
                            Voir les Posts
                        </a>
                    @else
                        <a href="{{ route('login') }}" class="btn btn-primary px-5 fw-semibold">
                            Se connecter
                        </a>
                           <a href="{{ route('posts.index') }}" class="btn btn-info px-5 fw-semibold mt-2">
                            Voir les Posts
                        </a>
                    @endauth

                </div>

            </div>

        </div>
    </div>

</div>

@endsection
