<?php



namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\MasarifController;
use App\Http\Controllers\CaisseController;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {

      
    return view('welcome');
});


Route::get('/landing', function () {
    return view('landing');
});




// لإظهار صفحة إضافة مصاريف مرتبطة ب Post
Route::get('/masarif/create/{post}', [MasarifController::class, 'create'])->name('masarif.create');
Route::resource('masarif', MasarifController::class)->except(['create']);


Route::get('/masarif/post/{id}', [MasarifController::class, 'index'])->name('masarif.post');
Route::resource('masarif', MasarifController::class);
Route::resource('caisse', CaisseController::class);
Route::get('/profile', [MasarifController::class, 'profile'])->name('masarif.profile');


//Route::get('/profile', [MasarifController::class, 'profile']);
use App\Http\Controllers\PostController;

Route::get('/posts', [PostController::class, 'index'])->name('posts.index');
Route::post('/posts', [PostController::class, 'store'])->name('posts.store');
Route::put('/posts/{post}', [PostController::class, 'update'])->name('posts.update');
Route::delete('/posts/{post}', [PostController::class, 'destroy'])->name('posts.destroy');


Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');
